/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.version;

import com.dynious.refinedrelocation.helper.LogHelper;
import com.dynious.refinedrelocation.version.VersionContainer;
import com.google.gson.Gson;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.net.URL;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.IOUtils;

public class VersionChecker
implements Runnable {
    private static VersionChecker instance = new VersionChecker();
    private static Gson gson = new Gson();
    private static final int VERSION_CHECK_ATTEMPTS = 3;
    private static final String REMOTE_VERSION_FILE = "https://raw.github.com/Dynious/RefinedRelocation/master/version.json";
    private static CheckState result = CheckState.UNINITIALIZED;
    private static VersionContainer.Version remoteVersion = null;
    public static boolean sentIMCMessage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkVersion() {
        result = CheckState.UNINITIALIZED;
        try {
            String json = IOUtils.toString((URL)new URL(REMOTE_VERSION_FILE));
            VersionContainer versionContainer = (VersionContainer)gson.fromJson(json, VersionContainer.class);
            VersionContainer.Version latest = versionContainer.getLatestFromMcVersion(Loader.instance().getMCVersionString());
            if (latest != null) {
                remoteVersion = latest;
                if (remoteVersion.getModVersion().equalsIgnoreCase("1.0.5")) {
                    result = CheckState.CURRENT;
                } else {
                    result = CheckState.OUTDATED;
                    VersionChecker.sendUpdateIMCMessage(latest);
                }
            } else {
                result = CheckState.MC_VERSION_NOT_FOUND;
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        finally {
            if (result == CheckState.UNINITIALIZED) {
                result = CheckState.ERROR;
            }
        }
    }

    public static void logResult() {
        if (result == CheckState.CURRENT || result == CheckState.OUTDATED) {
            LogHelper.info(VersionChecker.getResultMessage());
        } else {
            LogHelper.warning(VersionChecker.getResultMessage());
        }
    }

    public static String getResultMessage() {
        if (result == CheckState.UNINITIALIZED) {
            return "Version Checker Status: UNINITIALIZED";
        }
        if (result == CheckState.CURRENT) {
            return "Version Checker Status: CURRENT";
        }
        if (result == CheckState.OUTDATED && remoteVersion != null) {
            return String.format("Version Checker Status: OUTDATED! Using %s, latest %s, changelog: %s", "1.0.5", remoteVersion.getModVersion(), remoteVersion.getChangeLog());
        }
        if (result == CheckState.ERROR) {
            return "Version Checker Status: ERROR";
        }
        if (result == CheckState.FINAL_ERROR) {
            return "Version Checker Status: ENDED WITH ERROR";
        }
        if (result == CheckState.MC_VERSION_NOT_FOUND) {
            return "Version Checker Status: MC VERSION NOT SUPPORTED";
        }
        result = CheckState.ERROR;
        return "Version Checker Status: ERROR";
    }

    public static CheckState getResult() {
        return result;
    }

    public static VersionContainer.Version getRemoteVersion() {
        return remoteVersion;
    }

    public static void sendUpdateIMCMessage(VersionContainer.Version newVersion) {
        if (Loader.isModLoaded((String)"VersionChecker")) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("modDisplayName", "Refined Relocation");
            tag.func_74778_a("oldVersion", "1.0.5");
            tag.func_74778_a("newVersion", newVersion.getModVersion());
            tag.func_74778_a("updateUrl", newVersion.getUpdateURL());
            tag.func_74757_a("isDirectLink", true);
            tag.func_74778_a("changeLog", newVersion.getChangeLog());
            FMLInterModComms.sendRuntimeMessage((Object)"RefinedRelocation", (String)"VersionChecker", (String)"addUpdate", (NBTTagCompound)tag);
            sentIMCMessage = true;
        }
    }

    @Override
    public void run() {
        try {
            for (int count = 0; count < 2 && (result == CheckState.UNINITIALIZED || result == CheckState.ERROR); ++count) {
                VersionChecker.checkVersion();
                VersionChecker.logResult();
                if (result != CheckState.UNINITIALIZED && result != CheckState.ERROR) continue;
                Thread.sleep(1000L);
            }
            if (result == CheckState.ERROR) {
                result = CheckState.FINAL_ERROR;
                VersionChecker.logResult();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void execute() {
        new Thread(instance).start();
    }

    public static enum CheckState {
        UNINITIALIZED,
        CURRENT,
        OUTDATED,
        ERROR,
        FINAL_ERROR,
        MC_VERSION_NOT_FOUND;

    }
}

