/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.tileentity;

import com.dynious.refinedrelocation.api.APIUtils;
import com.dynious.refinedrelocation.api.tileentity.ISortingMember;
import com.dynious.refinedrelocation.api.tileentity.handlers.ISortingMemberHandler;
import com.dynious.refinedrelocation.tileentity.IDisguisable;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileSortingConnector
extends TileEntity
implements ISortingMember,
IDisguisable {
    private ISortingMemberHandler sortingHandler = APIUtils.createSortingMemberHandler(this);
    private boolean isFirstTick = true;
    public Block blockDisguisedAs = null;
    public int blockDisguisedMetadata = 0;

    @Override
    public boolean canDisguise() {
        return true;
    }

    @Override
    public boolean canDisguiseAs(Block block, int metadata) {
        return block.func_149662_c();
    }

    @Override
    public Block getDisguise() {
        return this.blockDisguisedAs;
    }

    @Override
    public int getDisguiseMeta() {
        return this.blockDisguisedMetadata;
    }

    @Override
    public void setDisguise(Block block, int metadata) {
        this.blockDisguisedAs = block;
        this.blockDisguisedMetadata = metadata;
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
        }
    }

    @Override
    public void clearDisguise() {
        this.setDisguise(null, 0);
    }

    public void func_145845_h() {
        if (this.isFirstTick) {
            this.sortingHandler.onTileAdded();
            this.isFirstTick = false;
        }
        super.func_145845_h();
    }

    @Override
    public ISortingMemberHandler getHandler() {
        return this.sortingHandler;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        int disguiseBlockId = compound.func_74762_e("disguisedId");
        if (disguiseBlockId != 0) {
            int disguisedMeta = compound.func_74762_e("disguisedMeta");
            this.setDisguise(Block.func_149729_e((int)disguiseBlockId), disguisedMeta);
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        if (this.blockDisguisedAs != null) {
            compound.func_74768_a("disguisedId", Block.func_149682_b((Block)this.blockDisguisedAs));
            compound.func_74768_a("disguisedMeta", this.blockDisguisedMetadata);
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        int disguiseBlockId = pkt.func_148857_g().func_74762_e("disguisedId");
        if (disguiseBlockId != 0) {
            int disguisedMeta = pkt.func_148857_g().func_74762_e("disguisedMeta");
            this.setDisguise(Block.func_149729_e((int)disguiseBlockId), disguisedMeta);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.blockDisguisedAs != null) {
            compound.func_74768_a("disguisedId", Block.func_149682_b((Block)this.blockDisguisedAs));
            compound.func_74768_a("disguisedMeta", this.blockDisguisedMetadata);
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, compound);
    }

    public void func_145843_s() {
        this.sortingHandler.onTileRemoved();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.sortingHandler.onTileRemoved();
        super.onChunkUnload();
    }
}

