/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.tileentity;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import com.dynious.refinedrelocation.helper.DirectionHelper;
import com.dynious.refinedrelocation.helper.EnergyType;
import com.dynious.refinedrelocation.helper.LoopHelper;
import com.dynious.refinedrelocation.lib.Mods;
import com.dynious.refinedrelocation.mods.IC2Helper;
import com.dynious.refinedrelocation.tileentity.ILoopable;
import com.dynious.refinedrelocation.tileentity.energy.TileUniversalElectricity;
import cpw.mods.fml.common.Optional;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TilePowerLimiter
extends TileUniversalElectricity
implements ILoopable {
    protected ForgeDirection connectedDirection = ForgeDirection.UNKNOWN;
    protected ForgeDirection previousConnectedDirection = ForgeDirection.UNKNOWN;
    protected IPowerReceptor powerReceptor;
    protected IEnergySink energySink;
    public boolean blocksChanged = true;
    private double maxAcceptedEnergy = 10.0;
    private boolean disablePower = false;
    private boolean redstoneToggle = false;
    private boolean oldState = false;

    public void setConnectedSide(int connectedSide) {
        this.connectedDirection = ForgeDirection.getOrientation((int)connectedSide);
        this.blocksChanged = true;
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    public ForgeDirection getConnectedDirection() {
        return this.connectedDirection;
    }

    public void setPowerReceptor(IPowerReceptor powerReceptor) {
        this.powerReceptor = powerReceptor;
    }

    public void setEnergySink(IEnergySink energySink) {
        if (this.energySink == null && energySink != null) {
            this.energySink = energySink;
            if (!this.field_145850_b.field_72995_K) {
                IC2Helper.addToEnergyNet(this);
            }
        } else if (this.energySink != null) {
            if (energySink == null && !this.field_145850_b.field_72995_K) {
                IC2Helper.removeFromEnergyNet(this);
            }
            this.energySink = energySink;
        }
    }

    public IPowerReceptor getPowerReceptor() {
        return this.powerReceptor;
    }

    public IEnergySink getEnergySink() {
        return this.energySink;
    }

    public double getMaxAcceptedEnergy() {
        return this.maxAcceptedEnergy;
    }

    public void setMaxAcceptedEnergy(double value) {
        this.maxAcceptedEnergy = value;
    }

    public void setDisablePower(boolean value) {
        if (value != this.disablePower) {
            this.disablePower = value;
            if (this.field_145850_b != null) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public boolean getDisablePower() {
        return this.disablePower;
    }

    public void setRedstoneToggle(boolean toggle) {
        this.redstoneToggle = toggle;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.newRedstoneState(this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    public boolean getRedstoneToggle() {
        return this.redstoneToggle;
    }

    public void newRedstoneState(boolean state) {
        if (this.redstoneToggle) {
            if (!this.oldState && state) {
                this.setDisablePower(!this.disablePower);
            }
            this.oldState = state;
        } else {
            this.setDisablePower(state);
        }
    }

    public void func_145843_s() {
        if (this.getEnergySink() != null && !this.field_145850_b.field_72995_K) {
            IC2Helper.removeFromEnergyNet(this);
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (this.getEnergySink() != null && !this.field_145850_b.field_72995_K) {
            IC2Helper.removeFromEnergyNet(this);
        }
        super.onChunkUnload();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.canConnect()) {
            TileEntity tile = null;
            if (this.connectedDirection != this.previousConnectedDirection) {
                tile = this.getConnectedTile();
                this.resetConnections();
                this.checkConnectedDirection(tile);
                this.previousConnectedDirection = this.connectedDirection;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.blocksChanged) {
                if (tile == null) {
                    tile = this.getConnectedTile();
                }
                if (tile == null) {
                    this.resetConnections();
                    this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                } else {
                    this.checkConnectedDirection(tile);
                }
                if (!this.field_145850_b.field_72995_K) {
                    this.newRedstoneState(this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                }
                this.blocksChanged = false;
            }
        }
    }

    protected void checkConnectedDirection(TileEntity tile) {
        if (tile != null && !LoopHelper.isLooping(this, tile)) {
            boolean updated = false;
            if (Mods.IS_BC_ENERGY_LOADED && tile instanceof IPowerReceptor) {
                if (this.getPowerReceptor() == null) {
                    updated = true;
                }
                this.setPowerReceptor((IPowerReceptor)tile);
            }
            if (Mods.IS_IC2_LOADED && tile instanceof IEnergySink) {
                if (this.getEnergySink() == null) {
                    updated = true;
                }
                this.setEnergySink((IEnergySink)tile);
            }
            if (updated || tile instanceof ILoopable) {
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            }
        }
    }

    protected void resetConnections() {
        this.setPowerReceptor(null);
        this.setEnergySink(null);
    }

    public List<EnergyType> getConnectionTypes() {
        ArrayList<EnergyType> connections = new ArrayList<EnergyType>();
        if (Mods.IS_BC_ENERGY_LOADED && this.getPowerReceptor() != null) {
            connections.add(EnergyType.MJ);
        }
        if (Mods.IS_IC2_LOADED && this.getEnergySink() != null) {
            connections.add(EnergyType.EU);
        }
        return connections;
    }

    public boolean canConnect() {
        return this.connectedDirection != ForgeDirection.UNKNOWN;
    }

    public TileEntity getConnectedTile() {
        return DirectionHelper.getTileAtSide(this, this.connectedDirection);
    }

    @Override
    public List<TileEntity> getConnectedTiles() {
        return Arrays.asList(DirectionHelper.getTileAtSide(this, this.connectedDirection));
    }

    @Optional.Method(modid="BuildCraft|Energy")
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection forgeDirection) {
        if (this.getPowerReceptor() != null && !this.getDisablePower()) {
            return this.getPowerReceptor().getPowerReceiver(forgeDirection.getOpposite());
        }
        return null;
    }

    @Optional.Method(modid="BuildCraft|Energy")
    public void doWork(PowerHandler powerHandler) {
        if (this.getPowerReceptor() != null) {
            this.getPowerReceptor().doWork(powerHandler);
        }
    }

    @Optional.Method(modid="BuildCraft|Energy")
    public World getWorld() {
        if (this.getPowerReceptor() != null) {
            return this.getPowerReceptor().getWorld();
        }
        return null;
    }

    @Optional.Method(modid="IC2")
    public double demandedEnergyUnits() {
        if (this.getEnergySink() != null && !this.getDisablePower()) {
            double demanded = this.getEnergySink().demandedEnergyUnits();
            if (demanded > EnergyType.EU.fromInternal(this.maxAcceptedEnergy)) {
                demanded = EnergyType.EU.fromInternal(this.maxAcceptedEnergy);
            }
            return demanded;
        }
        return 0.0;
    }

    @Optional.Method(modid="IC2")
    public double injectEnergyUnits(ForgeDirection forgeDirection, double v) {
        if (this.getEnergySink() != null && !this.getDisablePower()) {
            double storedEnergy = 0.0;
            if (v > EnergyType.EU.fromInternal(this.maxAcceptedEnergy)) {
                storedEnergy = v - EnergyType.EU.fromInternal(this.maxAcceptedEnergy);
                v = EnergyType.EU.fromInternal(this.maxAcceptedEnergy);
            }
            return this.getEnergySink().injectEnergyUnits(forgeDirection.getOpposite(), v) + storedEnergy;
        }
        return v;
    }

    @Optional.Method(modid="IC2")
    public int getMaxSafeInput() {
        if (this.getEnergySink() != null) {
            return this.getEnergySink().getMaxSafeInput();
        }
        return 0;
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(TileEntity tileEntity, ForgeDirection forgeDirection) {
        return this.getEnergySink() != null && this.getEnergySink().acceptsEnergyFrom(tileEntity, forgeDirection.getOpposite());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.setConnectedSide(compound.func_74771_c("side"));
        this.setMaxAcceptedEnergy(compound.func_74769_h("maxEnergy"));
        this.setDisablePower(compound.func_74767_n("disablePower"));
        this.setRedstoneToggle(compound.func_74767_n("toggle"));
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74774_a("side", (byte)this.connectedDirection.ordinal());
        compound.func_74780_a("maxEnergy", this.maxAcceptedEnergy);
        compound.func_74757_a("disablePower", this.getDisablePower());
        compound.func_74757_a("toggle", this.getRedstoneToggle());
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.setConnectedSide(pkt.func_148857_g().func_74771_c("side"));
        this.setDisablePower(pkt.func_148857_g().func_74767_n("disablePower"));
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("side", (byte)this.connectedDirection.ordinal());
        compound.func_74757_a("disablePower", this.getDisablePower());
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, compound);
    }

    public boolean rotateBlock() {
        this.setConnectedSide((this.getConnectedDirection().ordinal() + 1) % ForgeDirection.VALID_DIRECTIONS.length);
        return true;
    }
}

