/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.tileentity;

import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import com.dynious.refinedrelocation.helper.DirectionHelper;
import com.dynious.refinedrelocation.helper.IOHelper;
import com.dynious.refinedrelocation.helper.LoopHelper;
import com.dynious.refinedrelocation.lib.Mods;
import com.dynious.refinedrelocation.mods.IC2Helper;
import com.dynious.refinedrelocation.tileentity.ILoopable;
import com.dynious.refinedrelocation.tileentity.energy.TileUniversalElectricity;
import cpw.mods.fml.common.Optional;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@Optional.Interface(iface="buildcraft.api.power.IPowerEmitter", modid="BuildCraft|Energy")
public class TileBuffer
extends TileUniversalElectricity
implements ISidedInventory,
IFluidHandler,
IPowerEmitter,
ILoopable {
    protected TileEntity[] tiles = new TileEntity[ForgeDirection.VALID_DIRECTIONS.length];
    protected boolean firstRun = true;
    protected int bufferedSide = -1;
    public ItemStack bufferedItemStack = null;
    public boolean containsItemStack = false;
    private PowerHandler powerHandler;

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.firstRun) {
                this.onBlocksChanged();
                this.firstRun = false;
                this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.bufferedItemStack == null ? 0 : 1);
                if (Mods.IS_IC2_LOADED) {
                    IC2Helper.addToEnergyNet(this);
                }
            }
            if (this.bufferedItemStack != null) {
                this.bufferedItemStack = this.outputItemStack(this.bufferedItemStack, this.bufferedSide);
                if (this.bufferedItemStack == null) {
                    this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, 0);
                }
            }
        }
    }

    public void onBlocksChanged() {
        this.tiles = new TileEntity[ForgeDirection.VALID_DIRECTIONS.length];
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = DirectionHelper.getTileAtSide(this, direction);
            if (LoopHelper.isLooping(this, tile)) continue;
            this.tiles[direction.ordinal()] = tile;
        }
    }

    public ItemStack setBufferedItemStack(ItemStack itemStack, int side) {
        if (this.bufferedItemStack == null) {
            this.bufferedItemStack = itemStack;
            this.bufferedSide = side;
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, 1);
            return null;
        }
        return itemStack;
    }

    public List<ForgeDirection> getOutputSidesForInsertDirection(ForgeDirection insertDirection) {
        ArrayList<ForgeDirection> outputSides = new ArrayList<ForgeDirection>();
        ForgeDirection oppositeDirection = insertDirection.getOpposite();
        if (oppositeDirection != ForgeDirection.UNKNOWN) {
            outputSides.add(oppositeDirection);
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (dir == insertDirection || dir == oppositeDirection) continue;
            outputSides.add(dir);
        }
        return outputSides;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{var1};
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        if (this.bufferedItemStack != null) {
            return false;
        }
        ItemStack addingItemStack = itemstack.func_77946_l();
        for (ForgeDirection outputSide : this.getOutputSidesForInsertDirection(ForgeDirection.getOrientation((int)side))) {
            TileEntity tile = this.tiles[outputSide.ordinal()];
            if (tile == null || IOHelper.insert(tile, addingItemStack, outputSide.getOpposite(), true) != null) continue;
            return true;
        }
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        return null;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        if ((itemstack = this.outputItemStack(itemstack, slot)) != null && this.setBufferedItemStack(itemstack, slot) != null) {
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, itemstack));
        }
    }

    public ItemStack outputItemStack(ItemStack itemstack, int inputSide) {
        for (ForgeDirection outputSide : this.getOutputSidesForInsertDirection(ForgeDirection.getOrientation((int)inputSide))) {
            if ((itemstack = this.insertItemStack(itemstack, outputSide.ordinal())) != null && itemstack.field_77994_a != 0) continue;
            return null;
        }
        return itemstack;
    }

    public ItemStack insertItemStack(ItemStack itemstack, int side) {
        return IOHelper.insert(this.tiles[side], itemstack, ForgeDirection.getOrientation((int)side).getOpposite(), false);
    }

    public String func_145825_b() {
        return "buffer";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public boolean rotateBlock() {
        return false;
    }

    public boolean func_145842_c(int eventId, int eventData) {
        switch (eventId) {
            case 1: {
                this.containsItemStack = eventData == 1;
                return true;
            }
        }
        return super.func_145842_c(eventId, eventData);
    }

    @Override
    public List<TileEntity> getConnectedTiles() {
        return Arrays.asList(this.tiles);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("bufferedSide")) {
            this.bufferedSide = compound.func_74771_c("bufferedSide");
            NBTTagList tagList = compound.func_150295_c("Items", 10);
            this.bufferedItemStack = ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(0));
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        if (this.bufferedItemStack != null) {
            compound.func_74774_a("bufferedSide", (byte)this.bufferedSide);
            NBTTagList nbttaglist = new NBTTagList();
            NBTTagCompound tag = new NBTTagCompound();
            this.bufferedItemStack.func_77955_b(tag);
            nbttaglist.func_74742_a((NBTBase)tag);
            compound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int inputAmount = resource.amount;
        for (ForgeDirection outputSide : this.getOutputSidesForInsertDirection(from)) {
            if ((resource = this.insertFluidStack(resource, outputSide.ordinal())) != null && resource.amount != 0) continue;
            return inputAmount;
        }
        return inputAmount - resource.amount;
    }

    public FluidStack insertFluidStack(FluidStack fluidStack, int side) {
        TileEntity tile = this.tiles[side];
        if (tile != null && tile instanceof IFluidHandler) {
            fluidStack.amount -= ((IFluidHandler)tile).fill(ForgeDirection.getOrientation((int)side).getOpposite(), fluidStack, true);
        }
        if (fluidStack.amount == 0) {
            return null;
        }
        return fluidStack;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo(null, Integer.MAX_VALUE)};
    }

    @Optional.Method(modid="IC2")
    public double demandedEnergyUnits() {
        return Double.MAX_VALUE;
    }

    @Optional.Method(modid="IC2")
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        double inputAmount = amount;
        for (ForgeDirection outputSide : this.getOutputSidesForInsertDirection(directionFrom)) {
            if ((amount = this.insertEnergyUnits(amount, outputSide.ordinal())) != 0.0) continue;
            return inputAmount;
        }
        return inputAmount - amount;
    }

    @Optional.Method(modid="IC2")
    public double insertEnergyUnits(double amount, int side) {
        TileEntity tile = this.tiles[side];
        if (tile != null && tile instanceof IEnergySink) {
            amount -= ((IEnergySink)tile).injectEnergyUnits(ForgeDirection.getOrientation((int)side).getOpposite(), Math.min(amount, (double)((IEnergySink)tile).getMaxSafeInput()));
        }
        return amount;
    }

    @Optional.Method(modid="IC2")
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K && Mods.IS_IC2_LOADED) {
            IC2Helper.removeFromEnergyNet(this);
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (!this.field_145850_b.field_72995_K && Mods.IS_IC2_LOADED) {
            IC2Helper.removeFromEnergyNet(this);
        }
        super.onChunkUnload();
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Optional.Method(modid="BuildCraft|Energy")
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection forgeDirection) {
        return this.getPowerReceiver();
    }

    @Optional.Method(modid="BuildCraft|Energy")
    public PowerHandler.PowerReceiver getPowerReceiver() {
        if (this.powerHandler == null) {
            this.powerHandler = new PowerHandler((IPowerReceptor)this, PowerHandler.Type.MACHINE);
            this.powerHandler.configure((double)0.1f, 500.0, (double)0.01f, 500.0);
            this.powerHandler.configurePowerPerdition(0, 0);
        }
        return this.powerHandler.getPowerReceiver();
    }

    @Optional.Method(modid="BuildCraft|Energy")
    public void doWork(PowerHandler powerHandler) {
        for (ForgeDirection outputSide : this.getOutputSidesForInsertDirection(ForgeDirection.UNKNOWN)) {
            double usedEnergy = powerHandler.getEnergyStored() - this.insertMinecraftJoules(powerHandler.getEnergyStored(), outputSide.ordinal());
            powerHandler.useEnergy(usedEnergy, usedEnergy, true);
            if (powerHandler.getEnergyStored() != 0.0) continue;
            return;
        }
    }

    @Optional.Method(modid="BuildCraft|Energy")
    public double insertMinecraftJoules(double amount, int side) {
        PowerHandler.PowerReceiver powerReceiver;
        TileEntity tile = this.tiles[side];
        if (tile != null && tile instanceof IPowerReceptor && (powerReceiver = ((IPowerReceptor)tile).getPowerReceiver(ForgeDirection.getOrientation((int)side).getOpposite())) != null) {
            amount -= powerReceiver.receiveEnergy(PowerHandler.Type.PIPE, amount, ForgeDirection.getOrientation((int)side).getOpposite());
        }
        return amount;
    }

    @Optional.Method(modid="BuildCraft|Energy")
    public World getWorld() {
        return this.func_145831_w();
    }

    @Optional.Method(modid="BuildCraft|Energy")
    public boolean canEmitPowerFrom(ForgeDirection direction) {
        return true;
    }
}

