/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.tileentity;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import com.dynious.refinedrelocation.helper.DirectionHelper;
import com.dynious.refinedrelocation.helper.LoopHelper;
import com.dynious.refinedrelocation.lib.Mods;
import com.dynious.refinedrelocation.mods.IC2Helper;
import com.dynious.refinedrelocation.tileentity.IDisguisable;
import com.dynious.refinedrelocation.tileentity.ILoopable;
import com.dynious.refinedrelocation.tileentity.energy.TileUniversalElectricity;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileBlockExtender
extends TileUniversalElectricity
implements ISidedInventory,
IFluidHandler,
IDisguisable,
ILoopable {
    protected ForgeDirection connectedDirection = ForgeDirection.UNKNOWN;
    protected ForgeDirection previousConnectedDirection = ForgeDirection.UNKNOWN;
    protected IInventory inventory;
    protected int[] accessibleSlots;
    protected IFluidHandler fluidHandler;
    protected IPowerReceptor powerReceptor;
    protected IEnergySink energySink;
    protected TileEntity[] tiles = new TileEntity[ForgeDirection.VALID_DIRECTIONS.length];
    public boolean blocksChanged = true;
    protected boolean isRedstonePowered = false;
    protected boolean isRedstoneEnabled = true;
    public Block blockDisguisedAs = null;
    public int blockDisguisedMetadata = 0;

    @Override
    public boolean canDisguise() {
        return true;
    }

    @Override
    public boolean canDisguiseAs(Block block, int metadata) {
        return block.func_149662_c();
    }

    @Override
    public Block getDisguise() {
        return this.blockDisguisedAs;
    }

    @Override
    public int getDisguiseMeta() {
        return this.blockDisguisedMetadata;
    }

    @Override
    public void setDisguise(Block block, int metadata) {
        this.blockDisguisedAs = block;
        this.blockDisguisedMetadata = metadata;
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
        }
    }

    @Override
    public void clearDisguise() {
        this.setDisguise(null, 0);
    }

    public void setConnectedSide(int connectedSide) {
        this.connectedDirection = ForgeDirection.getOrientation((int)connectedSide);
        this.blocksChanged = true;
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    public ForgeDirection getConnectedDirection() {
        return this.connectedDirection;
    }

    public void setInventory(IInventory inventory) {
        this.inventory = inventory;
        if (inventory != null) {
            this.accessibleSlots = new int[inventory.func_70302_i_()];
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                this.accessibleSlots[i] = i;
            }
        }
    }

    public void setFluidHandler(IFluidHandler fluidHandler) {
        this.fluidHandler = fluidHandler;
    }

    @Optional.Method(modid="BuildCraft|Energy")
    public void setPowerReceptor(IPowerReceptor powerReceptor) {
        this.powerReceptor = powerReceptor;
    }

    @Optional.Method(modid="IC2")
    public void setEnergySink(IEnergySink energySink) {
        if (this.energySink == null && energySink != null) {
            this.energySink = energySink;
            if (!this.field_145850_b.field_72995_K) {
                IC2Helper.addToEnergyNet(this);
            }
        } else if (this.energySink != null) {
            if (energySink == null && !this.field_145850_b.field_72995_K) {
                IC2Helper.removeFromEnergyNet(this);
            }
            this.energySink = energySink;
        }
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    @Optional.Method(modid="BuildCraft|Energy")
    public IPowerReceptor getPowerReceptor() {
        return this.powerReceptor;
    }

    @Optional.Method(modid="IC2")
    public IEnergySink getEnergySink() {
        return this.energySink;
    }

    public TileEntity[] getTiles() {
        return this.tiles;
    }

    public void func_145843_s() {
        if (Loader.isModLoaded((String)"IC2") && this.getEnergySink() != null) {
            IC2Helper.removeFromEnergyNet(this);
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        if (Loader.isModLoaded((String)"IC2") && this.getEnergySink() != null) {
            IC2Helper.removeFromEnergyNet(this);
        }
        super.onChunkUnload();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.canConnect()) {
            TileEntity tile = null;
            if (this.connectedDirection != this.previousConnectedDirection) {
                tile = this.getConnectedTile();
                this.resetConnections();
                this.checkConnectedDirection(tile);
                this.previousConnectedDirection = this.connectedDirection;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.blocksChanged) {
                if (tile == null) {
                    tile = this.getConnectedTile();
                }
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    if (direction == this.connectedDirection) continue;
                    this.tiles[direction.ordinal()] = DirectionHelper.getTileAtSide(this, direction);
                }
                this.checkRedstonePower();
                if (tile == null) {
                    this.resetConnections();
                    this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                } else {
                    this.checkConnectedDirection(tile);
                }
                this.blocksChanged = false;
            }
        }
    }

    protected void checkConnectedDirection(TileEntity tile) {
        if (tile != null && !LoopHelper.isLooping(this, tile)) {
            boolean updated = false;
            if (tile instanceof IInventory) {
                if (this.getInventory() == null) {
                    updated = true;
                }
                this.setInventory((IInventory)tile);
            }
            if (tile instanceof IFluidHandler) {
                if (this.getFluidHandler() == null) {
                    updated = true;
                }
                this.setFluidHandler((IFluidHandler)tile);
            }
            if (Mods.IS_BC_ENERGY_LOADED && tile instanceof IPowerReceptor) {
                if (this.getPowerReceptor() == null) {
                    updated = true;
                }
                this.setPowerReceptor((IPowerReceptor)tile);
            }
            if (Mods.IS_IC2_LOADED && tile instanceof IEnergySink) {
                if (this.getEnergySink() == null) {
                    updated = true;
                }
                this.setEnergySink((IEnergySink)tile);
            }
            if (updated) {
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    protected void resetConnections() {
        this.setInventory(null);
        this.setFluidHandler(null);
        if (Mods.IS_BC_ENERGY_LOADED) {
            this.setPowerReceptor(null);
        }
        if (Mods.IS_IC2_LOADED) {
            this.setEnergySink(null);
        }
    }

    public boolean hasConnection() {
        if (this.getInventory() != null || this.getFluidHandler() != null) {
            return true;
        }
        if (Mods.IS_BC_ENERGY_LOADED && this.getPowerReceptor() != null) {
            return true;
        }
        return Mods.IS_IC2_LOADED && this.getEnergySink() != null;
    }

    public List<String> getConnectionTypes() {
        ArrayList<String> connections = new ArrayList<String>();
        if (this.getInventory() != null) {
            connections.add("Inventory");
        }
        if (this.getFluidHandler() != null) {
            connections.add("Fluid Transmission");
        }
        if (Mods.IS_BC_ENERGY_LOADED && this.getPowerReceptor() != null) {
            connections.add("Buildcraft Energy");
        }
        if (Mods.IS_IC2_LOADED && this.getEnergySink() != null) {
            connections.add("IC2 Energy");
        }
        return connections;
    }

    public ForgeDirection getInputSide(ForgeDirection side) {
        return this.connectedDirection.getOpposite();
    }

    public boolean canConnect() {
        return this.connectedDirection != ForgeDirection.UNKNOWN;
    }

    public TileEntity getConnectedTile() {
        return DirectionHelper.getTileAtSide(this, this.connectedDirection);
    }

    @Override
    public List<TileEntity> getConnectedTiles() {
        return Arrays.asList(DirectionHelper.getTileAtSide(this, this.connectedDirection));
    }

    public void checkRedstonePower() {
        boolean wasRedstonePowered = this.isRedstoneTransmissionActive();
        this.setRedstoneTransmissionActive(false);
        if (this.isRedstoneTransmissionEnabled()) {
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                int indirectPowerLevelFromDirection;
                if (direction == this.connectedDirection || (indirectPowerLevelFromDirection = this.field_145850_b.func_72878_l(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ, direction.ordinal())) <= 0) continue;
                this.setRedstoneTransmissionActive(true);
                break;
            }
        }
        if (this.isRedstoneTransmissionActive() != wasRedstonePowered) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147460_e(this.field_145851_c + this.connectedDirection.offsetX, this.field_145848_d + this.connectedDirection.offsetY, this.field_145849_e + this.connectedDirection.offsetZ, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
    }

    public int isPoweringTo(int side) {
        ForgeDirection realDir = ForgeDirection.getOrientation((int)side).getOpposite();
        if (this.isRedstoneTransmissionActive() && this.connectedDirection == realDir) {
            return 15;
        }
        return 0;
    }

    public boolean canConnectRedstone(int side) {
        if (!this.isRedstoneTransmissionEnabled()) {
            return false;
        }
        ForgeDirection realDirection = ForgeDirection.UNKNOWN;
        switch (side) {
            case -1: {
                realDirection = ForgeDirection.UP;
                break;
            }
            case 0: {
                realDirection = ForgeDirection.NORTH;
                break;
            }
            case 1: {
                realDirection = ForgeDirection.EAST;
                break;
            }
            case 2: {
                realDirection = ForgeDirection.SOUTH;
                break;
            }
            case 3: {
                realDirection = ForgeDirection.WEST;
            }
        }
        return realDirection != ForgeDirection.UNKNOWN && realDirection == this.connectedDirection;
    }

    public int[] func_94128_d(int i) {
        if (this.getInventory() != null) {
            if (this.getInventory() instanceof ISidedInventory) {
                return ((ISidedInventory)this.getInventory()).func_94128_d(this.getInputSide(ForgeDirection.getOrientation((int)i)).ordinal());
            }
            return this.accessibleSlots;
        }
        return new int[0];
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int i2) {
        if (this.getInventory() != null) {
            if (this.getInventory() instanceof ISidedInventory) {
                return ((ISidedInventory)this.getInventory()).func_102007_a(i, itemStack, this.getInputSide(ForgeDirection.getOrientation((int)i2)).ordinal());
            }
            return true;
        }
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int i2) {
        if (this.getInventory() != null) {
            if (this.getInventory() instanceof ISidedInventory) {
                return ((ISidedInventory)this.getInventory()).func_102008_b(i, itemStack, this.getInputSide(ForgeDirection.getOrientation((int)i2)).ordinal());
            }
            return true;
        }
        return false;
    }

    public int func_70302_i_() {
        if (this.getInventory() != null) {
            return this.getInventory().func_70302_i_();
        }
        return 0;
    }

    public ItemStack func_70301_a(int i) {
        if (this.getInventory() != null) {
            return this.getInventory().func_70301_a(i);
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int i2) {
        if (this.getInventory() != null) {
            return this.getInventory().func_70298_a(i, i2);
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.getInventory() != null) {
            return this.getInventory().func_70304_b(i);
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        if (this.getInventory() != null) {
            this.getInventory().func_70299_a(i, itemStack);
        }
    }

    public String func_145825_b() {
        if (this.getInventory() != null) {
            return this.getInventory().func_145825_b();
        }
        return null;
    }

    public boolean func_145818_k_() {
        return this.getInventory() != null && this.getInventory().func_145818_k_();
    }

    public int func_70297_j_() {
        if (this.getInventory() != null) {
            return this.getInventory().func_70297_j_();
        }
        return 0;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.getInventory() != null && this.getInventory().func_70300_a(entityPlayer);
    }

    public void func_70295_k_() {
        if (this.getInventory() != null) {
            this.getInventory().func_70295_k_();
        }
    }

    public void func_70305_f() {
        if (this.getInventory() != null) {
            this.getInventory().func_70305_f();
        }
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return this.getInventory() != null && this.getInventory().func_94041_b(i, itemStack);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.getFluidHandler() != null) {
            return this.getFluidHandler().fill(this.getInputSide(from), resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.getFluidHandler() != null) {
            return this.getFluidHandler().drain(this.getInputSide(from), resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.getFluidHandler() != null) {
            return this.getFluidHandler().drain(this.getInputSide(from), maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.getFluidHandler() != null && this.getFluidHandler().canFill(this.getInputSide(from), fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.getFluidHandler() != null && this.getFluidHandler().canDrain(this.getInputSide(from), fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.getFluidHandler() != null) {
            return this.getFluidHandler().getTankInfo(this.getInputSide(from));
        }
        return new FluidTankInfo[0];
    }

    @Optional.Method(modid="BuildCraft|Energy")
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection forgeDirection) {
        if (this.getPowerReceptor() != null) {
            return this.getPowerReceptor().getPowerReceiver(this.getInputSide(forgeDirection));
        }
        return null;
    }

    @Optional.Method(modid="BuildCraft|Energy")
    public void doWork(PowerHandler powerHandler) {
        if (this.getPowerReceptor() != null) {
            this.getPowerReceptor().doWork(powerHandler);
        }
    }

    @Optional.Method(modid="BuildCraft|Energy")
    public World getWorld() {
        if (this.getPowerReceptor() != null) {
            return this.getPowerReceptor().getWorld();
        }
        return null;
    }

    @Optional.Method(modid="IC2")
    public double demandedEnergyUnits() {
        if (this.getEnergySink() != null) {
            return this.getEnergySink().demandedEnergyUnits();
        }
        return 0.0;
    }

    @Optional.Method(modid="IC2")
    public double injectEnergyUnits(ForgeDirection forgeDirection, double v) {
        if (this.getEnergySink() != null) {
            return this.getEnergySink().injectEnergyUnits(this.getInputSide(forgeDirection), v);
        }
        return 0.0;
    }

    @Optional.Method(modid="IC2")
    public int getMaxSafeInput() {
        if (this.getEnergySink() != null) {
            return this.getEnergySink().getMaxSafeInput();
        }
        return 0;
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(TileEntity tileEntity, ForgeDirection forgeDirection) {
        return this.getEnergySink() != null && this.getEnergySink().acceptsEnergyFrom(tileEntity, this.getInputSide(forgeDirection));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.setConnectedSide(compound.func_74771_c("side"));
        this.setRedstoneTransmissionEnabled(compound.func_74767_n("redstoneEnabled"));
        int disguiseBlockId = compound.func_74762_e("disguisedId");
        if (disguiseBlockId != 0) {
            int disguisedMeta = compound.func_74762_e("disguisedMeta");
            this.setDisguise(Block.func_149729_e((int)disguiseBlockId), disguisedMeta);
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74774_a("side", (byte)this.connectedDirection.ordinal());
        compound.func_74757_a("redstoneEnabled", this.isRedstoneTransmissionEnabled());
        if (this.blockDisguisedAs != null) {
            compound.func_74768_a("disguisedId", Block.func_149682_b((Block)this.blockDisguisedAs));
            compound.func_74768_a("disguisedMeta", this.blockDisguisedMetadata);
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.setConnectedSide(pkt.func_148857_g().func_74771_c("side"));
        this.setRedstoneTransmissionActive(pkt.func_148857_g().func_74767_n("redstone"));
        this.setRedstoneTransmissionEnabled(pkt.func_148857_g().func_74767_n("redstoneEnabled"));
        int disguiseBlockId = pkt.func_148857_g().func_74762_e("disguisedId");
        if (disguiseBlockId != 0) {
            int disguisedMeta = pkt.func_148857_g().func_74762_e("disguisedMeta");
            this.setDisguise(Block.func_149729_e((int)disguiseBlockId), disguisedMeta);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("side", (byte)this.connectedDirection.ordinal());
        compound.func_74757_a("redstone", this.isRedstoneTransmissionActive());
        compound.func_74757_a("redstoneEnabled", this.isRedstoneTransmissionEnabled());
        if (this.blockDisguisedAs != null) {
            compound.func_74768_a("disguisedId", Block.func_149682_b((Block)this.blockDisguisedAs));
            compound.func_74768_a("disguisedMeta", this.blockDisguisedMetadata);
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, compound);
    }

    public boolean rotateBlock() {
        this.setConnectedSide((this.getConnectedDirection().ordinal() + 1) % ForgeDirection.VALID_DIRECTIONS.length);
        return true;
    }

    public boolean isRedstoneTransmissionEnabled() {
        return this.isRedstoneEnabled;
    }

    public void setRedstoneTransmissionEnabled(boolean state) {
        boolean wasRedstoneEnabled = this.isRedstoneTransmissionEnabled();
        this.isRedstoneEnabled = state;
        if (this.field_145850_b != null && this.isRedstoneTransmissionEnabled() != wasRedstoneEnabled) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.checkRedstonePower();
        }
    }

    public boolean isRedstoneTransmissionActive() {
        return this.isRedstonePowered;
    }

    public void setRedstoneTransmissionActive(boolean state) {
        this.isRedstonePowered = state;
    }
}

