/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.tileentity;

import buildcraft.api.power.PowerHandler;
import com.dynious.refinedrelocation.tileentity.IAdvancedTile;
import com.dynious.refinedrelocation.tileentity.TileBuffer;
import com.google.common.primitives.Bytes;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class TileAdvancedBuffer
extends TileBuffer
implements IAdvancedTile {
    private byte[] outputPrioritiesArrayProxy = new byte[]{0, 1, 2, 3, 4, 5};
    private List<Byte> outputPriorities = new ArrayList<Byte>(Bytes.asList((byte[])this.outputPrioritiesArrayProxy));
    private boolean spreadItems = false;
    private ForgeDirection lastItemOutputSide = ForgeDirection.UNKNOWN;
    private ForgeDirection lastFluidOutputSide = ForgeDirection.UNKNOWN;
    private ForgeDirection lastBCEnergyOutputSide = ForgeDirection.UNKNOWN;
    private ForgeDirection lastIC2EnergyOutputSide = ForgeDirection.UNKNOWN;
    public static final byte NULL_PRIORITY = (byte)ForgeDirection.VALID_DIRECTIONS.length;

    @Override
    public byte[] getInsertDirection() {
        return this.outputPrioritiesArrayProxy;
    }

    @Override
    public void setInsertDirection(int from, int value) {
        this.setPriorityOfSideTo(from, value);
    }

    public void setPriorityOfSideTo(int side, int priority) {
        priority = Math.min(NULL_PRIORITY, Math.max(0, priority));
        if (this.getPriority(side) < priority && priority == this.outputPriorities.size()) {
            priority = NULL_PRIORITY;
        }
        this.outputPriorities.remove(new Byte((byte)side));
        if (priority != NULL_PRIORITY) {
            this.outputPriorities.add(Math.min(this.outputPriorities.size(), priority), (byte)side);
        }
        for (int i = 0; i < this.outputPrioritiesArrayProxy.length; ++i) {
            this.outputPrioritiesArrayProxy[i] = this.getPriority(i);
        }
    }

    public byte getPriority(int side) {
        int priority = this.outputPriorities.indexOf((byte)side);
        if (priority == -1) {
            priority = NULL_PRIORITY;
        }
        return (byte)priority;
    }

    @Override
    public byte getMaxStackSize() {
        return 0;
    }

    @Override
    public void setMaxStackSize(byte maxStackSize) {
    }

    @Override
    public boolean getSpreadItems() {
        return this.spreadItems;
    }

    @Override
    public void setSpreadItems(boolean spreadItems) {
        this.spreadItems = spreadItems;
    }

    @Override
    public List<ForgeDirection> getOutputSidesForInsertDirection(ForgeDirection insertDirection) {
        ArrayList<ForgeDirection> outputSides = new ArrayList<ForgeDirection>();
        for (Byte prioritySide : this.outputPriorities) {
            ForgeDirection side = ForgeDirection.getOrientation((int)prioritySide.byteValue());
            if (side == insertDirection) continue;
            outputSides.add(side);
        }
        return outputSides;
    }

    public List<ForgeDirection> getOutputSidesForInsertDirection(ForgeDirection insertDirection, ForgeDirection lastOutputSide) {
        ArrayList<ForgeDirection> outputSides = new ArrayList<ForgeDirection>();
        if (this.outputPriorities.size() > 0) {
            int startPriorityIndex = (this.outputPriorities.indexOf((byte)lastOutputSide.ordinal()) + 1) % this.outputPriorities.size();
            int priorityIndexOfSide = startPriorityIndex;
            for (int i = 0; i < this.outputPriorities.size(); ++i) {
                ForgeDirection side = ForgeDirection.getOrientation((int)this.outputPriorities.get(priorityIndexOfSide).byteValue());
                if (side != insertDirection) {
                    outputSides.add(side);
                }
                priorityIndexOfSide = (priorityIndexOfSide + 1) % this.outputPriorities.size();
            }
        }
        return outputSides;
    }

    @Override
    public ItemStack outputItemStack(ItemStack itemstack, int inputSide) {
        if (this.spreadItems) {
            boolean didInsert;
            List<ForgeDirection> outputSides = this.getOutputSidesForInsertDirection(ForgeDirection.getOrientation((int)inputSide), this.lastItemOutputSide);
            ItemStack tempStack = itemstack.func_77946_l();
            tempStack.field_77994_a = 1;
            do {
                didInsert = false;
                Iterator<ForgeDirection> i$ = outputSides.iterator();
                while (i$.hasNext()) {
                    ForgeDirection outputSide;
                    this.lastItemOutputSide = outputSide = i$.next();
                    ItemStack returnedStack = this.insertItemStack(tempStack.func_77946_l(), outputSide.ordinal());
                    if (returnedStack != null && returnedStack.field_77994_a != 0) continue;
                    --itemstack.field_77994_a;
                    didInsert = true;
                    if (itemstack != null && itemstack.field_77994_a != 0) continue;
                    return null;
                }
            } while (didInsert);
        } else {
            return super.outputItemStack(itemstack, inputSide);
        }
        return itemstack;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int inputAmount = resource.amount;
        if (this.spreadItems) {
            boolean didFill;
            List<ForgeDirection> outputSides = this.getOutputSidesForInsertDirection(from, this.lastFluidOutputSide);
            FluidStack tempStack = resource.copy();
            tempStack.amount = outputSides.isEmpty() ? 0 : (int)Math.ceil(resource.amount / outputSides.size());
            do {
                didFill = false;
                Iterator<ForgeDirection> i$ = outputSides.iterator();
                while (i$.hasNext()) {
                    ForgeDirection outputSide;
                    this.lastFluidOutputSide = outputSide = i$.next();
                    FluidStack returnedStack = this.insertFluidStack(tempStack.copy(), outputSide.ordinal());
                    if (returnedStack != null && returnedStack.amount != 0) continue;
                    int amountFilled = returnedStack == null ? tempStack.amount : tempStack.amount - returnedStack.amount;
                    resource.amount -= Math.min(resource.amount, amountFilled);
                    didFill = true;
                    if (resource != null && resource.amount != 0) continue;
                    return inputAmount;
                }
            } while (didFill);
        } else {
            return super.fill(from, resource, doFill);
        }
        return inputAmount - resource.amount;
    }

    @Override
    @Optional.Method(modid="IC2")
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        double inputAmount = amount;
        if (this.spreadItems) {
            boolean didInject;
            List<ForgeDirection> outputSides = this.getOutputSidesForInsertDirection(directionFrom, this.lastIC2EnergyOutputSide);
            double amountPerStack = outputSides.isEmpty() ? 0.0 : amount / (double)outputSides.size();
            do {
                didInject = false;
                Iterator<ForgeDirection> i$ = outputSides.iterator();
                while (i$.hasNext()) {
                    ForgeDirection outputSide;
                    this.lastIC2EnergyOutputSide = outputSide = i$.next();
                    double amountLeft = this.insertEnergyUnits(amountPerStack, outputSide.ordinal());
                    if (amountLeft == amountPerStack) continue;
                    amount -= Math.min(amount, amountPerStack - amountLeft);
                    didInject = true;
                    if (amount != 0.0) continue;
                    return inputAmount;
                }
            } while (didInject);
        } else {
            return super.injectEnergyUnits(directionFrom, amount);
        }
        return inputAmount - amount;
    }

    @Override
    @Optional.Method(modid="BuildCraft|Energy")
    public void doWork(PowerHandler powerHandler) {
        if (this.spreadItems) {
            boolean didUseEnergy;
            List<ForgeDirection> outputSides = this.getOutputSidesForInsertDirection(ForgeDirection.UNKNOWN, this.lastBCEnergyOutputSide);
            double amountPerStack = outputSides.isEmpty() ? 0.0 : powerHandler.getEnergyStored() / (double)outputSides.size();
            do {
                didUseEnergy = false;
                Iterator<ForgeDirection> i$ = outputSides.iterator();
                while (i$.hasNext()) {
                    ForgeDirection outputSide;
                    this.lastBCEnergyOutputSide = outputSide = i$.next();
                    double usedEnergy = powerHandler.getEnergyStored() - this.insertMinecraftJoules(amountPerStack, outputSide.ordinal());
                    if (!(usedEnergy > 0.0)) continue;
                    powerHandler.useEnergy(usedEnergy, usedEnergy, true);
                    didUseEnergy = true;
                    if (powerHandler.getEnergyStored() != 0.0) continue;
                    return;
                }
            } while (didUseEnergy);
        } else {
            super.doWork(powerHandler);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.outputPriorities.clear();
        byte[] byteArrayPriorities = compound.func_74770_j("insertPriority");
        for (int priority = 0; priority < byteArrayPriorities.length; ++priority) {
            this.setPriorityOfSideTo(byteArrayPriorities[priority], priority);
        }
        for (byte i = 0; i < this.outputPrioritiesArrayProxy.length; i = (byte)(i + 1)) {
            if (this.outputPriorities.contains(i)) continue;
            this.outputPrioritiesArrayProxy[i] = NULL_PRIORITY;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        byte[] byteArrayPriorities = new byte[this.outputPriorities.size()];
        for (int priority = 0; priority < this.outputPriorities.size(); ++priority) {
            byteArrayPriorities[priority] = this.outputPriorities.get(priority);
        }
        compound.func_74773_a("insertPriority", byteArrayPriorities);
    }
}

