/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.network.packet;

import com.dynious.refinedrelocation.api.tileentity.IRelocator;
import com.dynious.refinedrelocation.grid.relocator.TravellingItem;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class MessageItemList
implements IMessage,
IMessageHandler<MessageItemList, IMessage> {
    private int x;
    private int y;
    private int z;
    private List<TravellingItem> items;

    public MessageItemList() {
    }

    public MessageItemList(TileEntity tile, List<TravellingItem> items) {
        this.x = tile.field_145851_c;
        this.y = tile.field_145848_d;
        this.z = tile.field_145849_e;
        this.items = items;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.items = new ArrayList<TravellingItem>();
        int size = buf.readByte();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = ByteBufUtils.readItemStack((ByteBuf)buf);
            ArrayList<Byte> list = new ArrayList<Byte>();
            list.add(buf.readByte());
            byte input = buf.readByte();
            this.items.add(new TravellingItem(stack, list, input));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeByte(this.items.size());
        for (TravellingItem item : this.items) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)item.getItemStack());
            buf.writeByte((int)item.getOutputSide());
            buf.writeByte((int)item.getInputSide());
        }
    }

    public IMessage onMessage(MessageItemList message, MessageContext ctx) {
        TileEntity tile = FMLClientHandler.instance().getClient().field_71441_e.func_147438_o(message.x, message.y, message.z);
        if (tile != null) {
            for (TravellingItem item : message.items) {
                ((IRelocator)tile).receiveTravellingItem(item);
            }
        }
        return null;
    }
}

