/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.multiblock;

import com.dynious.refinedrelocation.multiblock.IMultiBlock;
import com.dynious.refinedrelocation.multiblock.IMultiBlockLeader;
import com.dynious.refinedrelocation.multiblock.MultiBlockRegistry;
import com.dynious.refinedrelocation.util.BlockAndMeta;
import com.dynious.refinedrelocation.util.MultiBlockAndMeta;
import com.dynious.refinedrelocation.util.Vector3;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public abstract class TileMultiBlockBase
extends TileEntity
implements IMultiBlockLeader {
    public int timer = 0;
    private boolean isFormed = false;
    protected int type = -1;

    public void func_145845_h() {
        ++this.timer;
        if (this.shouldAutoCheckFormation() && this.timer % 200 == 0) {
            this.checkMultiBlock();
        }
    }

    private void checkMultiBlock() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        IMultiBlock multiBlock = MultiBlockRegistry.getMultiBlock(this.getMultiBlockIdentifier());
        Vector3 leaderPos = multiBlock.getRelativeLeaderPos();
        for (int x = 0; x < multiBlock.getMultiBlockMap().getSizeX(); ++x) {
            for (int y = 0; y < multiBlock.getMultiBlockMap().getSizeY(); ++y) {
                for (int z = 0; z < multiBlock.getMultiBlockMap().getSizeZ(); ++z) {
                    BlockAndMeta blockAndMeta;
                    Object blockInfo = multiBlock.getMultiBlockMap().getBlockAndMetaAtPos(x, y, z);
                    if (blockInfo instanceof MultiBlockAndMeta) {
                        MultiBlockAndMeta multiBlockAndMeta = (MultiBlockAndMeta)blockInfo;
                        boolean foundBlock = false;
                        for (int i = 0; i < multiBlockAndMeta.getBlockAndMetas().size(); ++i) {
                            if (!this.checkFormation(multiBlockAndMeta.getBlockAndMetas().get(i), this.field_145851_c + x - leaderPos.getX(), this.field_145848_d + y - leaderPos.getY(), this.field_145849_e + z - leaderPos.getZ())) continue;
                            foundBlock = true;
                            this.type = i;
                            break;
                        }
                        if (foundBlock) continue;
                        if (this.isFormed) {
                            this.isFormed = false;
                            this.onFormationChange();
                        }
                        return;
                    }
                    if (!(blockInfo instanceof BlockAndMeta) || this.checkFormation(blockAndMeta = (BlockAndMeta)blockInfo, this.field_145851_c + x - leaderPos.getX(), this.field_145848_d + y - leaderPos.getY(), this.field_145849_e + z - leaderPos.getZ())) continue;
                    if (this.isFormed) {
                        this.isFormed = false;
                        this.onFormationChange();
                    }
                    return;
                }
            }
        }
        if (!this.isFormed) {
            this.isFormed = true;
            this.onFormationChange();
        }
    }

    private boolean checkFormation(BlockAndMeta blockInfo, int x, int y, int z) {
        if (blockInfo.getBlock() == Blocks.field_150350_a) {
            if (!this.field_145850_b.func_147437_c(x, y, z)) {
                return false;
            }
        } else if (blockInfo.getMeta() == -1) {
            Block block = this.field_145850_b.func_147439_a(x, y, z);
            if (block != blockInfo.getBlock()) {
                return false;
            }
        } else {
            Block block = this.field_145850_b.func_147439_a(x, y, z);
            int meta = this.field_145850_b.func_72805_g(x, y, z);
            if (block != blockInfo.getBlock() || meta != blockInfo.getMeta()) {
                return false;
            }
        }
        return true;
    }

    public boolean shouldAutoCheckFormation() {
        return true;
    }

    public boolean isFormed(boolean forceRecheck) {
        if (forceRecheck) {
            this.forceCheck();
        }
        return this.isFormed;
    }

    protected void onFormationChange() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void forceCheck() {
        this.checkMultiBlock();
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("isFormed", this.isFormed);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.isFormed = pkt.func_148857_g().func_74767_n("isFormed");
    }
}

