/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.mods;

import com.dynious.refinedrelocation.api.ModObjects;
import com.dynious.refinedrelocation.block.BlockSortingIronChest;
import com.dynious.refinedrelocation.block.ModBlocks;
import com.dynious.refinedrelocation.item.ItemSortingIronChest;
import com.dynious.refinedrelocation.renderer.ItemRendererSortingIronChest;
import com.dynious.refinedrelocation.renderer.RendererSortingIronChest;
import com.dynious.refinedrelocation.tileentity.TileSortingChest;
import com.dynious.refinedrelocation.tileentity.TileSortingIronChest;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cpw.mods.ironchest.IronChest;
import cpw.mods.ironchest.IronChestType;
import cpw.mods.ironchest.ItemChestChanger;
import cpw.mods.ironchest.TileEntityIronChest;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public class IronChestHelper {
    public static void addIronChestBlocks() {
        ModBlocks.sortingIronChest = new BlockSortingIronChest();
        ModObjects.sortingIronChest = new ItemStack((Block)ModBlocks.sortingIronChest);
        GameRegistry.registerBlock((Block)ModBlocks.sortingIronChest, ItemSortingIronChest.class, (String)"sortingIronChest");
    }

    public static void addIronChestRecipes() {
        int i;
        for (i = 0; i < IronChestType.values().length - 1; ++i) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)ModBlocks.sortingIronChest, 1, i), (Object[])new Object[]{"g g", " b ", "g g", Character.valueOf('g'), Items.field_151043_k, Character.valueOf('b'), new ItemStack((Block)IronChest.ironChestBlock, 1, i)});
        }
        for (i = 0; i < IronChestType.values().length - 1; ++i) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)IronChest.ironChestBlock, 1, i), (Object[])new Object[]{new ItemStack((Block)ModBlocks.sortingIronChest, 1, i)});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addIronChestRenders() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileSortingIronChest.class, (TileEntitySpecialRenderer)new RendererSortingIronChest());
        MinecraftForgeClient.registerItemRenderer((Item)ItemBlock.func_150898_a((Block)ModBlocks.sortingIronChest), (IItemRenderer)new ItemRendererSortingIronChest());
    }

    public static boolean upgradeToIronChest(World world, EntityPlayer player, int x, int y, int z) {
        TileEntity tile;
        ItemChestChanger chestChanger;
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemChestChanger && (chestChanger = (ItemChestChanger)player.func_70694_bm().func_77973_b()).getType().canUpgrade(IronChestType.WOOD) && (tile = world.func_147438_o(x, y, z)) instanceof TileSortingChest) {
            TileSortingChest tec = (TileSortingChest)tile;
            if (tec.numUsingPlayers > 0) {
                return false;
            }
            TileSortingIronChest newchest = new TileSortingIronChest(IronChestType.values()[chestChanger.getType().getTarget()]);
            ItemStack[] chestInventory = tec.inventory;
            ItemStack[] chestContents = (ItemStack[])chestInventory.clone();
            newchest.setFacing((byte)tec.getFacing());
            for (int i = 0; i < chestInventory.length; ++i) {
                chestInventory[i] = null;
            }
            NBTTagCompound tag = new NBTTagCompound();
            tec.getFilter().writeToNBT(tag);
            newchest.getFilter().readFromNBT(tag);
            world.func_147468_f(x, y, z);
            world.func_147465_d(x, y, z, (Block)ModBlocks.sortingIronChest, chestChanger.getType().getTarget(), 3);
            world.func_147455_a(x, y, z, (TileEntity)newchest);
            world.func_72921_c(x, y, z, chestChanger.getType().getTarget(), 3);
            System.arraycopy(chestContents, 0, newchest.chestContents, 0, Math.min(chestContents.length, newchest.func_70302_i_()));
            --player.func_70694_bm().field_77994_a;
            return true;
        }
        return false;
    }

    public static boolean upgradeIronToFilteringChest(TileEntity tile) {
        if (tile instanceof TileEntityIronChest && !(tile instanceof TileSortingIronChest)) {
            World world = tile.func_145831_w();
            TileEntityIronChest teic = (TileEntityIronChest)tile;
            int numUsers = (Integer)ObfuscationReflectionHelper.getPrivateValue(TileEntityIronChest.class, (Object)teic, (String[])new String[]{"numUsingPlayers"});
            if (numUsers > 0) {
                return false;
            }
            TileSortingIronChest chest = new TileSortingIronChest(teic.getType());
            ItemStack[] chestContents = (ItemStack[])teic.chestContents.clone();
            chest.setFacing(teic.getFacing());
            for (int i = 0; i < teic.chestContents.length; ++i) {
                teic.chestContents[i] = null;
            }
            world.func_147468_f(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
            world.func_147465_d(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, (Block)ModBlocks.sortingIronChest, teic.getType().ordinal(), 3);
            world.func_147455_a(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, (TileEntity)chest);
            world.func_72921_c(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, chest.getType().ordinal(), 3);
            System.arraycopy(chestContents, 0, chest.chestContents, 0, chest.func_70302_i_());
            return true;
        }
        return false;
    }
}

