/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.helper;

import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import com.dynious.refinedrelocation.api.tileentity.IRelocator;
import com.dynious.refinedrelocation.helper.ItemStackHelper;
import com.dynious.refinedrelocation.lib.Mods;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class IOHelper {
    public static ItemStack extract(IInventory inventory, ForgeDirection direction) {
        if (inventory instanceof ISidedInventory) {
            int[] accessibleSlotsFromSide;
            ISidedInventory isidedinventory = (ISidedInventory)inventory;
            for (int anAccessibleSlotsFromSide : accessibleSlotsFromSide = isidedinventory.func_94128_d(direction.ordinal())) {
                ItemStack stack = IOHelper.extract(inventory, direction, anAccessibleSlotsFromSide);
                if (stack == null) continue;
                return stack;
            }
        } else {
            int j = inventory.func_70302_i_();
            for (int k = 0; k < j; ++k) {
                ItemStack stack = IOHelper.extract(inventory, direction, k);
                if (stack == null) continue;
                return stack;
            }
        }
        return null;
    }

    public static ItemStack extract(IInventory inventory, ForgeDirection direction, int slot) {
        ItemStack itemstack = inventory.func_70301_a(slot);
        if (itemstack != null && IOHelper.canExtractItemFromInventory(inventory, itemstack, slot, direction.ordinal())) {
            inventory.func_70299_a(slot, null);
            return itemstack;
        }
        return null;
    }

    public static ItemStack insert(TileEntity tile, ItemStack itemStack, ForgeDirection side, boolean simulate) {
        if (tile instanceof IRelocator) {
            return ((IRelocator)tile).insert(itemStack, side.ordinal(), simulate);
        }
        if (Mods.IS_BC_TRANS_LOADED && tile instanceof IPipeTile) {
            IPipeTile pipe = (IPipeTile)tile;
            if (pipe.isPipeConnected(side)) {
                int size = pipe.injectItem(itemStack, !simulate, side);
                itemStack.field_77994_a -= size;
                if (itemStack.field_77994_a == 0) {
                    return null;
                }
                return itemStack;
            }
        } else if (tile instanceof IInventory) {
            return IOHelper.insert((IInventory)tile, itemStack, side.ordinal(), simulate);
        }
        return itemStack;
    }

    public static ItemStack insert(IInventory inventory, ItemStack itemStack, int side, boolean simulate) {
        if (inventory instanceof ISidedInventory && side > -1) {
            ISidedInventory isidedinventory = (ISidedInventory)inventory;
            int[] aint = isidedinventory.func_94128_d(side);
            for (int j = 0; j < aint.length && itemStack != null && itemStack.field_77994_a > 0; ++j) {
                itemStack = IOHelper.insert(inventory, itemStack, aint[j], side, simulate);
            }
        } else {
            int k = inventory.func_70302_i_();
            for (int l = 0; l < k && itemStack != null && itemStack.field_77994_a > 0; ++l) {
                itemStack = IOHelper.insert(inventory, itemStack, l, side, simulate);
            }
        }
        if (itemStack != null && itemStack.field_77994_a == 0) {
            itemStack = null;
        }
        return itemStack;
    }

    public static ItemStack insert(IInventory inventory, ItemStack itemStack, int slot, int side, boolean simulate) {
        ItemStack itemstack1 = inventory.func_70301_a(slot);
        if (IOHelper.canInsertItemToInventory(inventory, itemStack, slot, side)) {
            int max;
            boolean flag = false;
            if (itemstack1 == null) {
                int max2 = Math.min(itemStack.func_77976_d(), inventory.func_70297_j_());
                if (max2 >= itemStack.field_77994_a) {
                    if (!simulate) {
                        inventory.func_70299_a(slot, itemStack);
                        flag = true;
                    }
                    itemStack = null;
                } else if (!simulate) {
                    inventory.func_70299_a(slot, itemStack.func_77979_a(max2));
                    flag = true;
                } else {
                    itemStack.func_77979_a(max2);
                }
            } else if (ItemStackHelper.areItemStacksEqual(itemstack1, itemStack) && (max = Math.min(itemStack.func_77976_d(), inventory.func_70297_j_())) > itemstack1.field_77994_a) {
                int l = Math.min(itemStack.field_77994_a, max - itemstack1.field_77994_a);
                itemStack.field_77994_a -= l;
                if (!simulate) {
                    itemstack1.field_77994_a += l;
                    boolean bl = flag = l > 0;
                }
            }
            if (flag) {
                inventory.func_70296_d();
            }
        }
        return itemStack;
    }

    public static boolean canInsertItemToInventory(IInventory inventory, ItemStack itemStack, int slot, int side) {
        return inventory.func_94041_b(slot, itemStack) && (!(inventory instanceof ISidedInventory) || ((ISidedInventory)inventory).func_102007_a(slot, itemStack, side));
    }

    public static boolean canExtractItemFromInventory(IInventory inventory, ItemStack itemStack, int slot, int side) {
        return !(inventory instanceof ISidedInventory) || ((ISidedInventory)inventory).func_102008_b(slot, itemStack, side);
    }

    public static void dropInventory(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == null || itemStack.field_77994_a <= 0) continue;
            IOHelper.spawnItemInWorld(world, itemStack, x, y, z);
        }
    }

    public static void spawnItemInWorld(World world, ItemStack itemStack, double x, double y, double z) {
        if (world.field_72995_K) {
            return;
        }
        float dX = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float dY = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float dZ = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        EntityItem entityItem = new EntityItem(world, x + (double)dX, y + (double)dY, z + (double)dZ, new ItemStack(itemStack.func_77973_b(), itemStack.field_77994_a, itemStack.func_77960_j()));
        if (itemStack.func_77942_o()) {
            entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
        }
        float factor = 0.05f;
        entityItem.field_70159_w = world.field_73012_v.nextGaussian() * (double)factor;
        entityItem.field_70181_x = world.field_73012_v.nextGaussian() * (double)factor + (double)0.2f;
        entityItem.field_70179_y = world.field_73012_v.nextGaussian() * (double)factor;
        world.func_72838_d((Entity)entityItem);
        itemStack.field_77994_a = 0;
    }

    public static boolean canInterfaceWith(TileEntity tile, ForgeDirection side) {
        if (tile instanceof IRelocator) {
            return ((IRelocator)tile).connectsToSide(side.ordinal());
        }
        if (Mods.IS_BC_TRANS_LOADED && tile instanceof IPipeTile) {
            return true;
        }
        if (Mods.IS_BC_TRANS_LOADED && tile instanceof IPipeConnection) {
            return ((IPipeConnection)tile).overridePipeConnection(IPipeTile.PipeType.ITEM, side) != IPipeConnection.ConnectOverride.DISCONNECT;
        }
        if (tile instanceof IInventory) {
            return !(tile instanceof ISidedInventory) || ((ISidedInventory)tile).func_94128_d(side.ordinal()).length > 0;
        }
        return false;
    }
}

