/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.gui.widget;

import com.dynious.refinedrelocation.gui.IGuiParent;
import com.dynious.refinedrelocation.gui.widget.GuiRefinedRelocationButton;
import com.dynious.refinedrelocation.helper.BlockHelper;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.tileentity.TileWirelessBlockExtender;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiWirelessLinkStatus
extends GuiRefinedRelocationButton {
    public static final int linkedOffsetY = 80;
    public static final int unlinkedOffsetY = 112;
    protected TileWirelessBlockExtender tile;
    protected boolean linked;
    protected boolean lastLinked;
    protected String tooltipText;

    public GuiWirelessLinkStatus(IGuiParent parent, int x, int y, TileWirelessBlockExtender tile) {
        super(parent, x, y, 16, 16, 112, 112, null);
        this.tile = tile;
        this.update();
    }

    public void setLinked(boolean state) {
        this.linked = state;
        this.textureY = this.linked ? 80 : 112;
    }

    @Override
    public List<String> getTooltip(int mouseX, int mouseY) {
        List<String> tooltip = super.getTooltip(mouseX, mouseY);
        if (this.isMouseInsideBounds(mouseX, mouseY)) {
            String colorCode = "\u00a7";
            String grayColor = colorCode + "7";
            String yellowColor = colorCode + "e";
            tooltip.add(StatCollector.func_74838_a((String)Strings.WIRELESS_LINK));
            if (this.linked) {
                tooltip.add(grayColor + StatCollector.func_74837_a((String)Strings.LINKED_TO_AT, (Object[])new Object[]{BlockHelper.getBlockDisplayName(this.tile.func_145831_w(), this.tile.xConnected, this.tile.yConnected, this.tile.zConnected), this.tile.xConnected, this.tile.yConnected, this.tile.zConnected}));
                if (this.tile.hasConnection()) {
                    tooltip.add(grayColor + StatCollector.func_74838_a((String)Strings.CONNECTIONS) + ":");
                    List<String> connections = this.tile.getConnectionTypes();
                    for (int i = 0; i < connections.size(); ++i) {
                        connections.set(i, yellowColor + connections.get(i));
                    }
                    tooltip.addAll(connections);
                }
            } else {
                tooltip.add(grayColor + StatCollector.func_74838_a((String)Strings.UNLINKED));
            }
        }
        return tooltip;
    }

    @Override
    public void update() {
        boolean isLinked;
        super.update();
        boolean bl = isLinked = this.tile.xConnected != Integer.MAX_VALUE;
        if (this.lastLinked != isLinked) {
            this.setLinked(isLinked);
        }
    }
}

