/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.gui.widget;

import com.dynious.refinedrelocation.grid.relocator.RelocatorModuleExtraction;
import com.dynious.refinedrelocation.gui.IGuiParent;
import com.dynious.refinedrelocation.gui.widget.GuiButtonCounter;
import com.dynious.refinedrelocation.lib.Settings;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.network.NetworkHandler;
import com.dynious.refinedrelocation.network.packet.MessageTicksBetweenExtraction;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiButtonTicksBetweenExtractions
extends GuiButtonCounter {
    private RelocatorModuleExtraction module;

    public GuiButtonTicksBetweenExtractions(IGuiParent parent, int x, int y, RelocatorModuleExtraction module) {
        super(parent, x, y, 24, 20, 0, 0, Settings.RELOCATOR_MIN_TICKS_BETWEEN_EXTRACTION, Integer.MAX_VALUE, 1, 10);
        this.module = module;
        this.update();
    }

    @Override
    protected void onValueChangedByUser(double newValue) {
        if (this.module == null) {
            return;
        }
        this.module.setTicksBetweenExtraction((int)newValue);
        NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageTicksBetweenExtraction((int)newValue));
    }

    @Override
    public List<String> getTooltip(int mouseX, int mouseY) {
        List<String> subTooltip = super.getTooltip(mouseX, mouseY);
        if (this.isMouseInsideBounds(mouseX, mouseY)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(StatCollector.func_74838_a((String)Strings.TICKS_BETWEEN_EXT));
            tooltip.addAll(subTooltip);
            return tooltip;
        }
        return subTooltip;
    }

    @Override
    public void update() {
        if (this.module != null) {
            this.setValue(this.module.getTicksBetweenExtraction());
        }
        super.update();
    }
}

