/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.gui.widget;

import com.dynious.refinedrelocation.gui.IGuiParent;
import com.dynious.refinedrelocation.gui.widget.GuiRefinedRelocationButton;
import com.dynious.refinedrelocation.helper.EnergyType;
import com.dynious.refinedrelocation.tileentity.TilePowerLimiter;
import java.util.List;

public class GuiButtonEnergyTypes
extends GuiRefinedRelocationButton {
    private TilePowerLimiter tile;
    private EnergyType currentEnergyType;

    public GuiButtonEnergyTypes(IGuiParent parent, TilePowerLimiter tile) {
        super(parent, "");
        this.tile = tile;
        if (tile != null) {
            this.setNextType();
        }
    }

    public GuiButtonEnergyTypes(IGuiParent parent, int x, int y, int w, int h, TilePowerLimiter tile) {
        super(parent, x, y, w, h, 0, 0, "");
        this.tile = tile;
        if (tile != null) {
            this.setNextType();
        }
    }

    public void setValue(EnergyType energyType) {
        this.label.setText(energyType.name());
    }

    public EnergyType getCurrentEnergyType() {
        return this.currentEnergyType;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int type, boolean isShiftKeyDown) {
        if (this.isMouseInsideBounds(mouseX, mouseY) && (type == 0 || type == 1)) {
            if (this.tile != null) {
                this.setNextType();
            } else {
                this.label.setText("--");
            }
        }
        super.mouseClicked(mouseX, mouseY, type, isShiftKeyDown);
    }

    public void setNextType() {
        List<EnergyType> list = this.tile.getConnectionTypes();
        if (!list.isEmpty()) {
            EnergyType t;
            int i;
            int ordinal = this.currentEnergyType != null ? this.currentEnergyType.ordinal() : -1;
            for (i = ordinal + 1; i < EnergyType.values().length; ++i) {
                t = EnergyType.values()[i];
                if (t == EnergyType.MJ || !list.contains((Object)t)) continue;
                this.currentEnergyType = t;
                this.setValue(t);
                return;
            }
            for (i = 0; i < ordinal + 1; ++i) {
                t = EnergyType.values()[i];
                if (t == EnergyType.MJ || !list.contains((Object)t)) continue;
                this.currentEnergyType = t;
                this.setValue(t);
                return;
            }
        }
        this.label.setText("--");
    }
}

