/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid.relocator;

import com.dynious.refinedrelocation.helper.ItemStackHelper;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TravellingItem {
    public static final byte timePerRelocator = 10;
    private ItemStack itemStack;
    private List<Byte> path;
    public byte input;
    public byte counter;

    public TravellingItem(ItemStack itemStack, List<Byte> path, int inputSide) {
        this.itemStack = itemStack;
        this.path = path;
        this.input = (byte)inputSide;
    }

    public TravellingItem(ItemStack itemStack, List<Byte> path) {
        this.itemStack = itemStack;
        this.path = path;
        this.input = this.getPath().get(0);
        this.getPath().remove(0);
    }

    public int getStackSize() {
        return this.itemStack.field_77994_a;
    }

    public boolean isItemSameAs(ItemStack itemStack) {
        return ItemStackHelper.areItemStacksEqual(this.itemStack, itemStack);
    }

    public List<Byte> getPath() {
        return this.path;
    }

    public byte onOutput() {
        this.counter = 0;
        byte side = this.getPath().get(0);
        this.getPath().remove(0);
        this.input = (byte)ForgeDirection.OPPOSITES[side];
        return side;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public byte getInputSide() {
        return this.input;
    }

    public byte getOutputSide() {
        return this.path.get(0);
    }

    public float getClientSideProgress(float partialRenderTime) {
        return ((float)this.counter + partialRenderTime) / 9.0f;
    }

    public float getX(float clientSideProgress) {
        if (clientSideProgress <= 0.5f) {
            return 0.6f + (float)ForgeDirection.getOrientation((int)this.getInputSide()).offsetX * 0.5f - (float)ForgeDirection.getOrientation((int)this.getInputSide()).offsetX * clientSideProgress;
        }
        return 0.6f + (float)ForgeDirection.getOrientation((int)this.getOutputSide()).offsetX * clientSideProgress - (float)ForgeDirection.getOrientation((int)this.getOutputSide()).offsetX * 0.5f;
    }

    public float getY(float clientSideProgress) {
        if (clientSideProgress <= 0.5f) {
            return 0.6f + (float)ForgeDirection.getOrientation((int)this.getInputSide()).offsetY * 0.5f - (float)ForgeDirection.getOrientation((int)this.getInputSide()).offsetY * clientSideProgress;
        }
        return 0.6f + (float)ForgeDirection.getOrientation((int)this.getOutputSide()).offsetY * clientSideProgress - (float)ForgeDirection.getOrientation((int)this.getOutputSide()).offsetY * 0.5f;
    }

    public float getZ(float clientSideProgress) {
        if (clientSideProgress <= 0.5f) {
            return 0.6f + (float)ForgeDirection.getOrientation((int)this.getInputSide()).offsetZ * 0.5f - (float)ForgeDirection.getOrientation((int)this.getInputSide()).offsetZ * clientSideProgress;
        }
        return 0.6f + (float)ForgeDirection.getOrientation((int)this.getOutputSide()).offsetZ * clientSideProgress - (float)ForgeDirection.getOrientation((int)this.getOutputSide()).offsetZ * 0.5f;
    }

    public void writeToNBT(NBTTagCompound compound) {
        this.itemStack.func_77955_b(compound);
        compound.func_74773_a("path", Bytes.toArray(this.path));
        compound.func_74774_a("input", this.input);
        compound.func_74774_a("counter", this.counter);
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.itemStack = ItemStack.func_77949_a((NBTTagCompound)compound);
        this.path = Bytes.asList((byte[])compound.func_74770_j("path"));
        this.input = compound.func_74771_c("input");
        this.counter = compound.func_74771_c("counter");
    }

    public static TravellingItem createFromNBT(NBTTagCompound compound) {
        TravellingItem t = new TravellingItem(ItemStack.func_77949_a((NBTTagCompound)compound), new ArrayList<Byte>(Bytes.asList((byte[])compound.func_74770_j("path"))), compound.func_74771_c("input"));
        t.counter = compound.func_74771_c("counter");
        return t;
    }
}

