/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid.relocator;

import com.dynious.refinedrelocation.api.APIUtils;
import com.dynious.refinedrelocation.api.filter.RelocatorModuleBase;
import com.dynious.refinedrelocation.api.tileentity.IRelocator;
import com.dynious.refinedrelocation.gui.GuiModuleSneaky;
import com.dynious.refinedrelocation.gui.container.ContainerModuleSneaky;
import com.dynious.refinedrelocation.helper.IOHelper;
import com.dynious.refinedrelocation.item.ModItems;
import com.dynious.refinedrelocation.lib.Resources;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class RelocatorModuleSneaky
extends RelocatorModuleBase {
    private static IIcon icon;
    private int outputSide = -1;

    @Override
    public void init(IRelocator relocator, int side) {
        this.outputSide = ForgeDirection.OPPOSITES[side];
    }

    @Override
    public boolean onActivated(IRelocator relocator, EntityPlayer player, int side, ItemStack stack) {
        APIUtils.openRelocatorFilterGUI(relocator, player, side);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGUI(IRelocator relocator, EntityPlayer player) {
        return new GuiModuleSneaky(this);
    }

    @Override
    public Container getContainer(IRelocator relocator, EntityPlayer player) {
        return new ContainerModuleSneaky(this);
    }

    @Override
    public ItemStack outputToSide(IRelocator relocator, int side, TileEntity inventory, ItemStack stack, boolean simulate) {
        return IOHelper.insert(inventory, stack, ForgeDirection.getOrientation((int)this.outputSide), simulate);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.outputSide = compound.func_74771_c("outputSide");
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74774_a("outputSide", (byte)this.outputSide);
    }

    @Override
    public List<ItemStack> getDrops(IRelocator relocator, int side) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((Item)ModItems.relocatorModule, 1, 5));
        return list;
    }

    @Override
    public IIcon getIcon(IRelocator relocator, int side) {
        return icon;
    }

    @Override
    public void registerIcons(IIconRegister register) {
        icon = register.func_94245_a(Resources.MOD_ID + ":" + "relocatorModuleSneaky");
    }

    public int getOutputSide() {
        return this.outputSide;
    }

    public void setOutputSide(int outputSide) {
        this.outputSide = outputSide;
    }
}

