/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid.relocator;

import com.dynious.refinedrelocation.api.APIUtils;
import com.dynious.refinedrelocation.api.filter.IFilterGUI;
import com.dynious.refinedrelocation.api.filter.RelocatorModuleBase;
import com.dynious.refinedrelocation.api.tileentity.IFilterTileGUI;
import com.dynious.refinedrelocation.api.tileentity.IRelocator;
import com.dynious.refinedrelocation.grid.FilterStandard;
import com.dynious.refinedrelocation.gui.GuiFiltered;
import com.dynious.refinedrelocation.gui.container.ContainerFiltered;
import com.dynious.refinedrelocation.item.ModItems;
import com.dynious.refinedrelocation.lib.Resources;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;

public class RelocatorModuleFilter
extends RelocatorModuleBase {
    private static IIcon icon;
    private FilterStandard filter;
    private long lastChange = -401L;

    @Override
    public void init(IRelocator relocator, int side) {
        this.filter = new FilterStandard(this.getFilterTile(this, relocator));
    }

    @Override
    public boolean onActivated(IRelocator relocator, EntityPlayer player, int side, ItemStack stack) {
        APIUtils.openRelocatorFilterGUI(relocator, player, side);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGUI(IRelocator relocator, EntityPlayer player) {
        return new GuiFiltered(this.getFilterTile(this, relocator));
    }

    @Override
    public Container getContainer(IRelocator relocator, EntityPlayer player) {
        return new ContainerFiltered(this.getFilterTile(this, relocator));
    }

    @Override
    public boolean passesFilter(IRelocator relocator, int side, ItemStack stack, boolean input, boolean simulate) {
        return !simulate && relocator.getTileEntity().func_145831_w().func_82737_E() - this.lastChange > 400L || this.filter.passesFilter(stack);
    }

    @Override
    public List<ItemStack> getDrops(IRelocator relocator, int side) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((Item)ModItems.relocatorModule, 1, 1));
        return list;
    }

    private IFilterTileGUI getFilterTile(final RelocatorModuleFilter module, final IRelocator relocator) {
        return new IFilterTileGUI(){

            @Override
            public IFilterGUI getFilter() {
                return module.filter;
            }

            @Override
            public TileEntity getTileEntity() {
                return relocator.getTileEntity();
            }

            @Override
            public void onFilterChanged() {
                RelocatorModuleFilter.this.lastChange = relocator.getTileEntity().func_145831_w().func_82737_E();
                relocator.getTileEntity().func_70296_d();
            }
        };
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.filter.readFromNBT(compound);
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        this.filter.writeToNBT(compound);
    }

    @Override
    public IIcon getIcon(IRelocator relocator, int side) {
        return icon;
    }

    @Override
    public void registerIcons(IIconRegister register) {
        icon = register.func_94245_a(Resources.MOD_ID + ":" + "relocatorModuleFilter");
    }
}

