/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid.relocator;

import com.dynious.refinedrelocation.api.APIUtils;
import com.dynious.refinedrelocation.api.filter.RelocatorModuleBase;
import com.dynious.refinedrelocation.api.tileentity.IRelocator;
import com.dynious.refinedrelocation.gui.GuiModuleExtraction;
import com.dynious.refinedrelocation.gui.container.ContainerModuleExtraction;
import com.dynious.refinedrelocation.helper.IOHelper;
import com.dynious.refinedrelocation.item.ModItems;
import com.dynious.refinedrelocation.lib.Resources;
import com.dynious.refinedrelocation.lib.Settings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class RelocatorModuleExtraction
extends RelocatorModuleBase {
    private static IIcon icon;
    private byte tick = 0;
    private int lastCheckedSlot = 0;
    private int ticksBetweenExtraction = Settings.RELOCATOR_MIN_TICKS_BETWEEN_EXTRACTION;

    @Override
    public boolean onActivated(IRelocator relocator, EntityPlayer player, int side, ItemStack stack) {
        APIUtils.openRelocatorFilterGUI(relocator, player, side);
        return true;
    }

    @Override
    public void onUpdate(IRelocator relocator, int side) {
        this.tick = (byte)(this.tick + 1);
        if (this.tick >= this.ticksBetweenExtraction) {
            TileEntity tile = relocator.getConnectedInventories()[side];
            if (tile instanceof IInventory) {
                this.tryExtraction(relocator, (IInventory)tile, side, this.lastCheckedSlot);
            }
            this.tick = 0;
        }
    }

    public void tryExtraction(IRelocator relocator, IInventory inventory, int side, int firstChecked) {
        int slot = this.getNextSlot(inventory, ForgeDirection.getOrientation((int)side).getOpposite());
        ItemStack stack = inventory.func_70301_a(slot);
        if (stack != null && stack.field_77994_a != 0) {
            ItemStack returnedStack;
            if (IOHelper.canExtractItemFromInventory(inventory, stack, slot, ForgeDirection.OPPOSITES[side]) && ((returnedStack = relocator.insert(stack.func_77946_l(), side, false)) == null || stack.field_77994_a != returnedStack.field_77994_a)) {
                inventory.func_70299_a(slot, returnedStack);
            }
        } else if (firstChecked != this.lastCheckedSlot) {
            this.tryExtraction(relocator, inventory, side, firstChecked);
        }
    }

    public int getNextSlot(IInventory inventory, ForgeDirection direction) {
        if (inventory instanceof ISidedInventory) {
            ISidedInventory isidedinventory = (ISidedInventory)inventory;
            int[] accessibleSlotsFromSide = isidedinventory.func_94128_d(direction.ordinal());
            this.lastCheckedSlot = this.lastCheckedSlot < accessibleSlotsFromSide.length - 1 ? ++this.lastCheckedSlot : 0;
            return accessibleSlotsFromSide[this.lastCheckedSlot];
        }
        this.lastCheckedSlot = this.lastCheckedSlot < inventory.func_70302_i_() - 1 ? ++this.lastCheckedSlot : 0;
        return this.lastCheckedSlot;
    }

    public void setTicksBetweenExtraction(int ticks) {
        this.ticksBetweenExtraction = Math.max(Settings.RELOCATOR_MIN_TICKS_BETWEEN_EXTRACTION, ticks);
    }

    public int getTicksBetweenExtraction() {
        return this.ticksBetweenExtraction;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGUI(IRelocator relocator, EntityPlayer player) {
        return new GuiModuleExtraction(this);
    }

    @Override
    public Container getContainer(IRelocator relocator, EntityPlayer player) {
        return new ContainerModuleExtraction(this);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.ticksBetweenExtraction = compound.func_74762_e("ticksBetweenExt");
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("ticksBetweenExt", this.ticksBetweenExtraction);
    }

    @Override
    public List<ItemStack> getDrops(IRelocator relocator, int side) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((Item)ModItems.relocatorModule, 1, 3));
        return list;
    }

    @Override
    public IIcon getIcon(IRelocator relocator, int side) {
        return icon;
    }

    @Override
    public void registerIcons(IIconRegister register) {
        icon = register.func_94245_a(Resources.MOD_ID + ":" + "relocatorModuleExtraction");
    }
}

