/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid.relocator;

import com.dynious.refinedrelocation.api.tileentity.IRelocator;
import com.dynious.refinedrelocation.grid.relocator.ItemOrPath;
import com.dynious.refinedrelocation.grid.relocator.PathToRelocator;
import com.dynious.refinedrelocation.grid.relocator.TravellingItem;
import com.dynious.refinedrelocation.helper.IOHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class RelocatorGridLogic {
    private static List<TileEntity> checkedRelocators = new ArrayList<TileEntity>();

    public static TravellingItem findOutput(ItemStack itemStack, IRelocator relocator, int side) {
        PathToRelocator path = new PathToRelocator(relocator, new ArrayList<Byte>(Arrays.asList((byte)side)));
        ItemOrPath itemOrPath = RelocatorGridLogic.tryOutputAndReturnConnections(itemStack, path, side);
        if (itemOrPath.ITEM != null) {
            checkedRelocators.clear();
            return itemOrPath.ITEM;
        }
        while (!itemOrPath.PATHS.isEmpty()) {
            ListIterator<PathToRelocator> iterator = itemOrPath.PATHS.listIterator();
            while (iterator.hasNext()) {
                PathToRelocator pathToRelocator = iterator.next();
                ItemOrPath itemOrPath2 = RelocatorGridLogic.tryOutputAndReturnConnections(itemStack, pathToRelocator, -1);
                if (itemOrPath2.ITEM != null) {
                    checkedRelocators.clear();
                    return itemOrPath2.ITEM;
                }
                iterator.remove();
                for (PathToRelocator path2 : itemOrPath2.PATHS) {
                    iterator.add(path2);
                }
            }
        }
        checkedRelocators.clear();
        return null;
    }

    private static ItemOrPath tryOutputAndReturnConnections(ItemStack itemStack, PathToRelocator path, int excludedOutputSide) {
        TravellingItem item = RelocatorGridLogic.tryToOutput(itemStack, path, excludedOutputSide);
        if (item != null) {
            return new ItemOrPath(item);
        }
        checkedRelocators.add(path.RELOCATOR.getTileEntity());
        ArrayList<PathToRelocator> uncheckedRelocators = new ArrayList<PathToRelocator>();
        for (int i = 0; i < path.RELOCATOR.getConnectedRelocators().length; ++i) {
            IRelocator relocator1 = path.RELOCATOR.getConnectedRelocators()[i];
            if (relocator1 == null || checkedRelocators.contains(relocator1.getTileEntity()) || !path.RELOCATOR.passesFilter(itemStack, i, false, true) || !relocator1.passesFilter(itemStack, ForgeDirection.OPPOSITES[i], true, true)) continue;
            ArrayList newP = (ArrayList)path.PATH.clone();
            newP.add((byte)i);
            uncheckedRelocators.add(new PathToRelocator(relocator1, newP));
        }
        return new ItemOrPath(uncheckedRelocators);
    }

    private static TravellingItem tryToOutput(ItemStack itemStack, PathToRelocator path, int excludedSide) {
        for (int i = 0; i < path.RELOCATOR.getConnectedInventories().length; ++i) {
            ItemStack stack;
            TileEntity inventory;
            if (i == excludedSide || (inventory = path.RELOCATOR.getConnectedInventories()[i]) == null || !path.RELOCATOR.passesFilter(itemStack, i, false, true) || (stack = path.RELOCATOR.getRelocatorModule(i) != null ? path.RELOCATOR.getRelocatorModule(i).outputToSide(path.RELOCATOR, i, inventory, itemStack.func_77946_l(), true) : IOHelper.insert(inventory, itemStack.func_77946_l(), ForgeDirection.getOrientation((int)i).getOpposite(), true)) != null && stack.field_77994_a >= itemStack.field_77994_a) continue;
            ArrayList newPath = (ArrayList)path.PATH.clone();
            newPath.add((byte)i);
            if (stack != null) {
                stack.field_77994_a = itemStack.field_77994_a - stack.field_77994_a;
            } else {
                stack = itemStack.func_77946_l();
            }
            return new TravellingItem(stack, newPath);
        }
        return null;
    }
}

