/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid;

import com.dynious.refinedrelocation.api.tileentity.ISortingMember;
import com.dynious.refinedrelocation.api.tileentity.grid.IGrid;
import com.dynious.refinedrelocation.api.tileentity.handlers.IGridMemberHandler;
import com.dynious.refinedrelocation.api.tileentity.handlers.ISortingMemberHandler;
import com.dynious.refinedrelocation.grid.Grid;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class GridMemberHandler
implements IGridMemberHandler {
    protected TileEntity owner;
    protected IGrid grid;
    private boolean canJoinGroup = true;

    public GridMemberHandler(TileEntity owner) {
        this.owner = owner;
    }

    @Override
    public TileEntity getOwner() {
        return this.owner;
    }

    @Override
    public void onTileAdded() {
        if (this.owner.func_145831_w().field_72995_K) {
            return;
        }
        this.searchForLeader();
    }

    @Override
    public void onTileRemoved() {
        if (this.owner.func_145831_w().field_72995_K) {
            return;
        }
        this.canJoinGroup = false;
        if (this.getGrid() != null) {
            this.getGrid().removeMember(this);
            this.getGrid().resetMembers();
        }
    }

    private void searchForLeader() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            ISortingMemberHandler filteringMember;
            TileEntity tile = this.owner.func_145831_w().func_147438_o(this.owner.field_145851_c + direction.offsetX, this.owner.field_145848_d + direction.offsetY, this.owner.field_145849_e + direction.offsetZ);
            if (tile == null || !(tile instanceof ISortingMember) || !(filteringMember = ((ISortingMember)tile).getHandler()).canJoinGroup() || filteringMember.getGrid() == null) continue;
            if (this.grid == null) {
                this.setGrid(filteringMember.getGrid());
                continue;
            }
            if (filteringMember.getGrid() == this.getGrid()) continue;
            filteringMember.getGrid().mergeToGrid(this.getGrid());
        }
        if (this.getGrid() == null) {
            this.setGrid(this.createNewGrid());
        }
    }

    protected IGrid createNewGrid() {
        return new Grid();
    }

    @Override
    public IGrid getGrid() {
        return this.grid;
    }

    @Override
    public void setGrid(IGrid grid) {
        if (grid == this.getGrid()) {
            return;
        }
        this.grid = grid;
        if (this.grid != null) {
            this.grid.addMember(this);
        }
    }

    @Override
    public boolean canJoinGroup() {
        return this.canJoinGroup;
    }
}

