/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid;

import com.dynious.refinedrelocation.api.filter.IFilterGUI;
import com.dynious.refinedrelocation.api.tileentity.IFilterTileGUI;
import com.google.common.primitives.Booleans;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class FilterStandard
implements IFilterGUI {
    private static Field displayOnCreativeTab = ReflectionHelper.findField(Block.class, (String[])ObfuscationReflectionHelper.remapFieldNames((String)Block.class.getName(), (String[])new String[]{"displayOnCreativeTab", "field_149772_a", "a"}));
    private static Field tabToDisplayOn = ReflectionHelper.findField(Item.class, (String[])ObfuscationReflectionHelper.remapFieldNames((String)Item.class.getName(), (String[])new String[]{"tabToDisplayOn", "field_77701_a", "a"}));
    private static Field tabIndex = ReflectionHelper.findField(CreativeTabs.class, (String[])ObfuscationReflectionHelper.remapFieldNames((String)CreativeTabs.class.getName(), (String[])new String[]{"tabIndex", "field_78033_n", "n"}));
    private static Field tabLabel = ReflectionHelper.findField(CreativeTabs.class, (String[])ObfuscationReflectionHelper.remapFieldNames((String)CreativeTabs.class.getName(), (String[])new String[]{"tabLabel", "field_78034_o", "o"}));
    private static CreativeTabs[] tabs = CreativeTabs.field_78032_a;
    public static final int FILTER_SIZE = 12;
    private IFilterTileGUI tile;
    private boolean[] customFilters = new boolean[12];
    private boolean[] creativeTabs = new boolean[tabs.length];
    private String userFilter = "";
    private boolean blacklists = false;

    public FilterStandard(IFilterTileGUI tile) {
        this.tile = tile;
    }

    @Override
    public int getSize() {
        return this.creativeTabs.length - 2 + 12;
    }

    @Override
    public boolean passesFilter(ItemStack itemStack) {
        return this.isBlacklisting() ? !this.isInFilter(itemStack) : this.isInFilter(itemStack);
    }

    private boolean isInFilter(ItemStack itemStack) {
        if (itemStack != null) {
            String[] oreNames = null;
            if (this.getUserFilter() != null && !this.getUserFilter().isEmpty()) {
                String filter = this.getUserFilter().toLowerCase().replaceAll("\\s+", "");
                String itemName = null;
                for (String s : filter.split(",")) {
                    if (s.contains("!")) {
                        if (oreNames == null) {
                            oreNames = FilterStandard.getOreNames(itemStack);
                        }
                        s = s.replace("!", "");
                        for (String oreName : oreNames) {
                            if (!FilterStandard.stringMatchesWildcardPattern(oreName, s)) continue;
                            return true;
                        }
                        continue;
                    }
                    if (itemName == null) {
                        itemName = itemStack.func_82833_r().toLowerCase().replaceAll("\\s+", "");
                    }
                    if (!FilterStandard.stringMatchesWildcardPattern(itemName, s)) continue;
                    return true;
                }
            }
            if (Booleans.contains((boolean[])this.customFilters, (boolean)true)) {
                if (oreNames == null) {
                    oreNames = FilterStandard.getOreNames(itemStack);
                }
                for (String oreName : oreNames) {
                    if (this.customFilters[0] && (oreName.contains("ingot") || itemStack.func_77973_b() == Items.field_151042_j || itemStack.func_77973_b() == Items.field_151043_k)) {
                        return true;
                    }
                    if (this.customFilters[1] && oreName.contains("ore")) {
                        return true;
                    }
                    if (this.customFilters[2] && oreName.contains("log")) {
                        return true;
                    }
                    if (this.customFilters[3] && oreName.contains("plank")) {
                        return true;
                    }
                    if (this.customFilters[4] && oreName.contains("dust")) {
                        return true;
                    }
                    if (this.customFilters[5] && oreName.contains("crushed") && !oreName.contains("purified")) {
                        return true;
                    }
                    if (this.customFilters[6] && oreName.contains("purified")) {
                        return true;
                    }
                    if (this.customFilters[7] && oreName.contains("plate")) {
                        return true;
                    }
                    if (this.customFilters[8] && oreName.contains("gem")) {
                        return true;
                    }
                    if (this.customFilters[9] && itemStack.func_77973_b() instanceof ItemFood) {
                        return true;
                    }
                    if (this.customFilters[10] && oreName.contains("dye")) {
                        return true;
                    }
                    if (!this.customFilters[11] || !oreName.contains("nugget")) continue;
                    return true;
                }
            }
            if (Booleans.contains((boolean[])this.creativeTabs, (boolean)true)) {
                try {
                    CreativeTabs tab = itemStack.func_77973_b() instanceof ItemBlock ? (CreativeTabs)displayOnCreativeTab.get(Block.func_149729_e((int)ItemBlock.func_150891_b((Item)itemStack.func_77973_b()))) : (CreativeTabs)tabToDisplayOn.get(itemStack.func_77973_b());
                    if (tab != null) {
                        int index = tabIndex.getInt(tab);
                        for (int i = 0; i < this.creativeTabs.length; ++i) {
                            if (!this.creativeTabs[i] || index != i) continue;
                            return true;
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    @Override
    public void setValue(int place, boolean value) {
        if (place < this.customFilters.length) {
            this.customFilters[place] = value;
        } else {
            this.creativeTabs[this.getCreativeTab((int)place)] = value;
        }
        this.tile.onFilterChanged();
    }

    @Override
    public boolean getValue(int place) {
        if (place < this.customFilters.length) {
            return this.customFilters[place];
        }
        return this.creativeTabs[this.getCreativeTab(place)];
    }

    @Override
    public String getName(int place) {
        switch (place) {
            case 0: {
                return "All Ingots";
            }
            case 1: {
                return "All Ores";
            }
            case 2: {
                return "All Logs";
            }
            case 3: {
                return "All Planks";
            }
            case 4: {
                return "All Dusts";
            }
            case 5: {
                return "All Crushed Ores";
            }
            case 6: {
                return "All Purified Ores";
            }
            case 7: {
                return "All Plates";
            }
            case 8: {
                return "All Gems";
            }
            case 9: {
                return "All Food";
            }
            case 10: {
                return "All Dyes";
            }
            case 11: {
                return "All Nuggets";
            }
        }
        return I18n.func_135052_a((String)tabs[this.getCreativeTab(place)].func_78024_c(), (Object[])new Object[0]);
    }

    public int getCreativeTab(int place) {
        int index = place - 12;
        if (index >= 5) {
            ++index;
        }
        if (index >= 11) {
            ++index;
        }
        return index;
    }

    @Override
    public boolean isBlacklisting() {
        return this.blacklists;
    }

    @Override
    public void setBlacklists(boolean blacklists) {
        this.blacklists = blacklists;
        this.tile.onFilterChanged();
    }

    @Override
    public String getUserFilter() {
        return this.userFilter;
    }

    @Override
    public void setUserFilter(String userFilter) {
        this.userFilter = userFilter;
        this.tile.onFilterChanged();
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        int i;
        compound.func_74778_a("userFilter", this.getUserFilter());
        compound.func_74757_a("blacklists", this.isBlacklisting());
        for (i = 0; i < this.customFilters.length; ++i) {
            compound.func_74757_a("cumstomFilters" + i, this.customFilters[i]);
        }
        for (i = 0; i < this.creativeTabs.length; ++i) {
            compound.func_74757_a("creativeTabs" + i, this.creativeTabs[i]);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        int i;
        this.userFilter = compound.func_74779_i("userFilter");
        this.blacklists = compound.func_74767_n("blacklists");
        for (i = 0; i < this.customFilters.length; ++i) {
            this.customFilters[i] = compound.func_74767_n("cumstomFilters" + i);
        }
        for (i = 0; i < this.creativeTabs.length; ++i) {
            this.creativeTabs[i] = compound.func_74767_n("creativeTabs" + i);
        }
    }

    public static boolean stringMatchesWildcardPattern(String string, String wildcardPattern) {
        return wildcardPattern.startsWith("*") && wildcardPattern.length() > 1 ? (wildcardPattern.endsWith("*") && wildcardPattern.length() > 2 ? string.contains(wildcardPattern.substring(1, wildcardPattern.length() - 1)) : string.endsWith(wildcardPattern.substring(1))) : (wildcardPattern.endsWith("*") && wildcardPattern.length() > 1 ? string.startsWith(wildcardPattern.substring(0, wildcardPattern.length() - 1)) : string.equalsIgnoreCase(wildcardPattern));
    }

    public static String[] getOreNames(ItemStack itemStack) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)itemStack);
        String[] oreNames = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            oreNames[i] = OreDictionary.getOreName((int)ids[i]).toLowerCase().replaceAll("\\s+", "");
        }
        return oreNames;
    }

    public static void syncTabs(String[] tabLabels) {
        tabs = new CreativeTabs[tabLabels.length];
        for (int i = 0; i < tabLabels.length; ++i) {
            String label = tabLabels[i];
            for (CreativeTabs tab : CreativeTabs.field_78032_a) {
                if (!label.equalsIgnoreCase(tab.func_78013_b())) continue;
                FilterStandard.tabs[i] = tab;
            }
            if (tabs[i] != null) continue;
            FilterStandard.tabs[i] = FilterStandard.createNewFakeTab(label);
        }
    }

    public static String[] getLabels() {
        String[] labels = new String[CreativeTabs.field_78032_a.length];
        CreativeTabs[] creativeTabArray = CreativeTabs.field_78032_a;
        for (int i = 0; i < creativeTabArray.length; ++i) {
            try {
                labels[i] = (String)tabLabel.get(creativeTabArray[i]);
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return labels;
    }

    public static CreativeTabs createNewFakeTab(String tabName) {
        CreativeTabs oldTab = CreativeTabs.field_78032_a[0];
        CreativeTabs tab = new CreativeTabs(0, tabName){

            public Item func_78016_d() {
                return null;
            }
        };
        CreativeTabs.field_78032_a[0] = oldTab;
        return tab;
    }
}

