/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.block;

import com.dynious.refinedrelocation.RefinedRelocation;
import com.dynious.refinedrelocation.helper.BlockHelper;
import com.dynious.refinedrelocation.helper.DirectionHelper;
import com.dynious.refinedrelocation.helper.DistanceHelper;
import com.dynious.refinedrelocation.helper.GuiHelper;
import com.dynious.refinedrelocation.item.ModItems;
import com.dynious.refinedrelocation.lib.Settings;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.tileentity.TileAdvancedBlockExtender;
import com.dynious.refinedrelocation.tileentity.TileAdvancedFilteredBlockExtender;
import com.dynious.refinedrelocation.tileentity.TileBlockExtender;
import com.dynious.refinedrelocation.tileentity.TileFilteredBlockExtender;
import com.dynious.refinedrelocation.tileentity.TileWirelessBlockExtender;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockExtender
extends BlockContainer {
    public BlockExtender() {
        super(Material.field_151576_e);
        this.func_149663_c("blockExtender");
        this.func_149711_c(3.0f);
        this.func_149647_a(RefinedRelocation.tabRefinedRelocation);
    }

    public TileEntity func_149915_a(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileBlockExtender();
            }
            case 1: {
                return new TileAdvancedBlockExtender();
            }
            case 2: {
                return new TileFilteredBlockExtender();
            }
            case 3: {
                return new TileAdvancedFilteredBlockExtender();
            }
            case 4: {
                return new TileWirelessBlockExtender();
            }
        }
        return null;
    }

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        for (int j = 0; j < (Settings.DISABLE_WIRELESS_BLOCK_EXTENDER ? 4 : 5); ++j) {
            par3List.add(new ItemStack(item, 1, j));
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (player.func_70093_af()) {
            TileEntity tile;
            if (player.func_71045_bC() == null && (tile = world.func_147438_o(x, y, z)) != null && tile instanceof TileBlockExtender && !(tile instanceof TileWirelessBlockExtender)) {
                TileBlockExtender blockExtender;
                blockExtender.setRedstoneTransmissionEnabled(!(blockExtender = (TileBlockExtender)tile).isRedstoneTransmissionEnabled());
                if (world.field_72995_K) {
                    player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)Strings.REDSTONE_TRANSMISSION) + StatCollector.func_74838_a((String)(blockExtender.isRedstoneTransmissionEnabled() ? Strings.ENABLED : Strings.DISABLED))));
                }
                return true;
            }
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            if (tile instanceof TileWirelessBlockExtender && player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == ModItems.linker) {
                if (player.func_71045_bC().func_77942_o()) {
                    int tileZ;
                    int tileY;
                    NBTTagCompound tag = player.func_71045_bC().func_77978_p();
                    int tileX = tag.func_74762_e("tileX");
                    if (DistanceHelper.getDistanceSq(x, y, z, tileX, tileY = tag.func_74762_e("tileY"), tileZ = tag.func_74762_e("tileZ")) <= Settings.MAX_RANGE_WIRELESS_BLOCK_EXTENDER * Settings.MAX_RANGE_WIRELESS_BLOCK_EXTENDER) {
                        ((TileWirelessBlockExtender)tile).setLink(tileX, tileY, tileZ);
                        if (world.field_72995_K) {
                            player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)Strings.LINKED_WITH, (Object[])new Object[]{BlockHelper.getTileEntityDisplayName(tile), BlockHelper.getBlockDisplayName(tile.func_145831_w(), tileX, tileY, tileZ), tileX, tileY, tileZ})));
                        }
                    } else if (world.field_72995_K) {
                        player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)Strings.TOO_FAR, (Object[])new Object[]{BlockHelper.getTileEntityDisplayName(tile), Settings.MAX_RANGE_WIRELESS_BLOCK_EXTENDER})));
                    }
                } else if (((TileWirelessBlockExtender)tile).isLinked()) {
                    ((TileWirelessBlockExtender)tile).clearLink();
                    if (world.field_72995_K) {
                        player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)Strings.NO_LONGER_LINKED, (Object[])new Object[]{BlockHelper.getTileEntityDisplayName(tile)})));
                    }
                }
                return true;
            }
            return GuiHelper.openGui(player, tile);
        }
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileBlockExtender) {
            ((TileBlockExtender)tile).blocksChanged = true;
        }
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        return tile != null && tile instanceof TileBlockExtender && ((TileBlockExtender)tile).canConnectRedstone(side);
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_149709_b(world, x, y, z, side);
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileBlockExtender) {
            return ((TileBlockExtender)tile).isPoweringTo(side);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        TileBlockExtender tile = (TileBlockExtender)world.func_147438_o(x, y, z);
        if (!tile.isRedstoneTransmissionActive()) {
            return;
        }
        float f = (float)x + 0.5f;
        float f1 = (float)y + 0.5f + random.nextFloat() * 6.0f / 16.0f;
        float f2 = (float)z + 0.5f;
        float f3 = 0.6f;
        float f4 = random.nextFloat() * 0.6f - 0.3f;
        world.func_72869_a("reddust", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
        world.func_72869_a("reddust", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
        world.func_72869_a("reddust", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
        world.func_72869_a("reddust", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149747_d(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public int func_149701_w() {
        return 1;
    }

    protected String func_149641_N() {
        return "obsidian";
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        TileBlockExtender tile = (TileBlockExtender)worldObj.func_147438_o(x, y, z);
        return tile.rotateBlock();
    }

    public int func_149645_b() {
        return 0;
    }

    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        TileBlockExtender tile;
        Block blockDisguisedAs;
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity != null && tileEntity instanceof TileBlockExtender && (blockDisguisedAs = (tile = (TileBlockExtender)tileEntity).getDisguise()) != null) {
            return blockDisguisedAs.func_149720_d(world, x, y, z);
        }
        return super.func_149720_d(world, x, y, z);
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity != null && tileEntity instanceof TileBlockExtender) {
            TileBlockExtender tile = (TileBlockExtender)tileEntity;
            Block blockDisguisedAs = tile.getDisguise();
            int disguisedMeta = tile.blockDisguisedMetadata;
            if (blockDisguisedAs != null) {
                return blockDisguisedAs.func_149691_a(side, disguisedMeta);
            }
        }
        return super.func_149673_e(world, x, y, z, side);
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        TileBlockExtender tile;
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        TileEntity tileEntity = DirectionHelper.getTileAtSide(world, x, y, z, dir.getOpposite());
        if (tileEntity != null && tileEntity instanceof TileBlockExtender && (tile = (TileBlockExtender)tileEntity).getDisguise() != null) {
            return dir == tile.getConnectedDirection();
        }
        return false;
    }
}

