/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.api;

import com.dynious.refinedrelocation.api.IAPIHandler;
import com.dynious.refinedrelocation.api.filter.IFilterGUI;
import com.dynious.refinedrelocation.api.filter.IRelocatorModule;
import com.dynious.refinedrelocation.api.tileentity.IFilterTileGUI;
import com.dynious.refinedrelocation.api.tileentity.IRelocator;
import com.dynious.refinedrelocation.api.tileentity.handlers.ISortingInventoryHandler;
import com.dynious.refinedrelocation.api.tileentity.handlers.ISortingMemberHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public final class APIUtils {
    private static IAPIHandler apiHandler;

    public static void openFilteringGUI(EntityPlayer entityPlayer, World world, int x, int y, int z) {
        entityPlayer.openGui(apiHandler.getModInstance(), apiHandler.getFilteringGUIID(), world, x, y, z);
    }

    public static IFilterGUI createStandardFilter(IFilterTileGUI filterTile) {
        return apiHandler.createStandardFilter(filterTile);
    }

    public static ISortingMemberHandler createSortingMemberHandler(TileEntity owner) {
        return apiHandler.createSortingMemberHandler(owner);
    }

    public static ISortingInventoryHandler createSortingInventoryHandler(TileEntity owner) {
        return apiHandler.createSortingInventoryHandler(owner);
    }

    public static void registerRelocatorFilter(String identifier, Class<? extends IRelocatorModule> clazz) throws IllegalArgumentException {
        apiHandler.registerRelocatorFilter(identifier, clazz);
    }

    public static void openRelocatorFilterGUI(IRelocator relocator, EntityPlayer player, int side) {
        apiHandler.openRelocatorFilterGUI(relocator, player, side);
    }

    static {
        try {
            Class<?> c = Class.forName("com.dynious.refinedrelocation.APIHandler");
            apiHandler = (IAPIHandler)c.getField("instance").get(c);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

