/*
 * Decompiled with CFR 0.152.
 */
package com.thetorine.thirstmod.common;

import com.thetorine.thirstmod.common.ContentDrink;
import com.thetorine.thirstmod.common.ModDrinkLoader;
import com.thetorine.thirstmod.common.utils.ThirstUtils;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLModContainer;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ContainerType;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ContentLoader {
    public static List<String> addedfiles = new ArrayList<String>();
    public ContentDrink drink;
    public int metadata;
    public int replenish;
    public int colour;
    public String jmTop;
    public float saturation;
    public String name;
    public String shortName;
    public boolean alwaysDrinkable;
    public int maxStackSize;
    public float poisonChance;
    public boolean isShiny;
    public int foodHeal;
    public float satHeal;
    public boolean curesPotions;
    public int potionId;
    public int potionDuration;
    public int potionAmplifier;
    public ContentLoader loader;

    public ContentLoader(Side side) {
        this.loadMainFiles(side);
    }

    public void loadMainFiles(Side side) {
        int i;
        File contentDir = new File(ThirstUtils.getDir(), "/ThirstMod/Content Packs/");
        File modDir = new File(ThirstUtils.getDir(), "/ThirstMod/External Mods/");
        if (!contentDir.exists()) {
            contentDir.mkdirs();
        }
        if (!modDir.exists()) {
            modDir.mkdirs();
        }
        new ModDrinkLoader(new File(ThirstUtils.getDir()), modDir);
        LinkedList<File> contentList = new LinkedList<File>();
        LinkedList<String> drinkList = new LinkedList<String>();
        if (contentDir.listFiles().length > 0) {
            for (i = 0; i < contentDir.listFiles().length; ++i) {
                if (contentDir.listFiles()[i].isFile()) continue;
                contentList.add(contentDir.listFiles()[i]);
            }
        }
        for (i = 0; i < contentList.size(); ++i) {
            File files = (File)contentList.get(i);
            for (int j = 0; j < files.listFiles().length; ++j) {
                File fileInDir = files.listFiles()[j];
                if (!fileInDir.getName().endsWith(".txt")) continue;
                drinkList.add(fileInDir.getName());
                this.setDefaults();
                try {
                    this.init(new BufferedReader(new FileReader(fileInDir)), files.getName());
                    this.drink = (ContentDrink)((ContentDrink)new ContentDrink(this.replenish, this.saturation, this.alwaysDrinkable, this.colour).func_77655_b(this.shortName).func_77625_d(this.maxStackSize)).setEffect(this.isShiny).setPoisoningChance(this.poisonChance).setPotionEffect(this.potionId, this.potionDuration, this.potionDuration, 1.0f).setCuresPotions(this.curesPotions);
                    LanguageRegistry.addName((Object)((Object)this.drink), (String)this.name);
                    Item item = (Item)Item.field_150901_e.func_82594_a(this.jmTop);
                    ThirstUtils.addJMRecipe(item.func_77658_a(), new ItemStack((Item)this.drink));
                    this.addTextures(files);
                    GameRegistry.registerItem((Item)this.drink, (String)this.shortName);
                    if (addedfiles.contains(files.getName())) continue;
                    addedfiles.add(files.getName());
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        ThirstUtils.print(new String("Loaded Drink Packs: " + addedfiles).replace("[", "").replace("]", ""));
    }

    public void init(BufferedReader br, String fileDir) {
        while (true) {
            String line = null;
            try {
                line = br.readLine();
            }
            catch (Exception e) {
                break;
            }
            if (line == null) break;
            String[] colon = line.split(":");
            this.read(colon, fileDir);
        }
    }

    public void read(String[] colon, String fileDir) {
        if (colon[0].equals("Replenish")) {
            this.replenish = Integer.parseInt(colon[1]);
        }
        if (colon[0].equals("Saturation")) {
            this.saturation = Float.parseFloat(colon[1]);
        }
        if (colon[0].equals("Name")) {
            this.name = colon[1];
        }
        if (colon[0].equals("Colour")) {
            this.colour = Integer.parseInt(colon[1], 16);
        }
        if (colon[0].equals("ShortName")) {
            this.shortName = colon[1];
        }
        if (colon[0].equals("DBRecipe")) {
            this.jmTop = colon[1];
            this.metadata = Integer.parseInt(colon[2]);
        }
        if (colon[0].equals("AlwaysDrinkable")) {
            this.alwaysDrinkable = Boolean.parseBoolean(colon[1].toLowerCase());
        }
        if (colon[0].equals("MaxStackSize")) {
            this.maxStackSize = Integer.parseInt(colon[1]);
        }
        if (colon[0].equals("PoisonChance")) {
            this.poisonChance = Float.parseFloat(colon[1]);
        }
        if (colon[0].equals("Shiny")) {
            this.isShiny = Boolean.parseBoolean(colon[1].toLowerCase());
        }
        if (colon[0].equals("FoodHeal")) {
            this.foodHeal = Integer.parseInt(colon[1]);
            this.satHeal = Float.parseFloat(colon[2]);
        }
        if (colon[0].equals("PotionEffect")) {
            this.potionId = Integer.parseInt(colon[1]);
            this.potionDuration = Integer.parseInt(colon[2]);
            this.potionAmplifier = Integer.parseInt(colon[3]);
        }
        if (colon[0].equals("CuresPotions")) {
            this.curesPotions = Boolean.parseBoolean(colon[1]);
        }
    }

    public void setDefaults() {
        this.metadata = 0;
        this.replenish = 0;
        this.jmTop = "";
        this.saturation = 0.0f;
        this.name = "";
        this.shortName = "";
        this.alwaysDrinkable = false;
        this.maxStackSize = 0;
        this.poisonChance = 0.0f;
        this.isShiny = false;
        this.foodHeal = 0;
        this.satHeal = 0.0f;
        this.potionId = 0;
        this.potionDuration = 0;
        this.potionAmplifier = 0;
        this.curesPotions = false;
    }

    public void addTextures(File file) throws Exception {
        ThirstUtils.addURLToSystemClassLoader(file.toURI().toURL());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("modid", "thirstmod");
        map.put("name", "ThirstMod: " + file.getName());
        map.put("version", "1.8.0");
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            ModCandidate candidate = new ModCandidate(ThirstUtils.getParentSources()[0], file, ContainerType.DIR);
            FMLModContainer container = new FMLModContainer("tarun1998.thirstmod.common.ThirstMod", candidate, map);
            container.bindMetadata(MetadataCollection.from(null, (String)""));
            FMLClientHandler.instance().addModAsResource((ModContainer)container);
        }
    }
}

