/*
 * Decompiled with CFR 0.152.
 */
package com.thetorine.thirstmod.common;

import com.thetorine.thirstmod.client.StatsHolder;
import com.thetorine.thirstmod.common.PlayerHandler;
import com.thetorine.thirstmod.common.ThirstMod;
import com.thetorine.thirstmod.common.utils.DrinkLists;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ContentDrink
extends Item {
    private int thirstReplenish;
    private float saturationReplenish;
    private boolean alwaysDrinkable;
    private int potionId;
    private int potionDuration;
    private int potionAmplifier;
    private float potionEffectProbability;
    private Item returnItem = Items.field_151069_bo;
    public String username;
    public boolean curesPotion;
    private float poisonChance;
    private int colour;
    private int foodHeal;
    private float satHeal;
    private IIcon drinkable;
    private IIcon overlay;

    public ContentDrink(int replenish, float saturation, boolean alwaysDrinkable, int colour) {
        if (alwaysDrinkable) {
            this.alwaysDrinkable = true;
        }
        this.func_77637_a(ThirstMod.drinkTab);
        this.thirstReplenish = replenish;
        this.saturationReplenish = saturation;
        DrinkLists.addDrink(new ItemStack((Item)this), replenish);
        this.colour = colour;
    }

    public ItemStack func_77654_b(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!world.field_72995_K) {
            Random rand;
            --itemstack.field_77994_a;
            PlayerHandler.getPlayer(entityplayer.getDisplayName()).getStats().addStats(this.thirstReplenish, this.saturationReplenish);
            if (this.poisonChance > 0.0f && ThirstMod.CONFIG.POISON_ON && (rand = new Random()).nextFloat() < this.poisonChance) {
                PlayerHandler.getPlayer(entityplayer.getDisplayName()).getStats().getPoison().startPoison();
            }
            if (this.curesPotion) {
                entityplayer.curePotionEffects(new ItemStack(Items.field_151117_aB));
            }
            if (this.foodHeal > 0 && this.satHeal > 0.0f) {
                entityplayer.func_71024_bL().func_75122_a(this.foodHeal, this.satHeal);
            }
            if (this.potionId > 0 && world.field_73012_v.nextFloat() < this.potionEffectProbability) {
                entityplayer.func_70690_d(new PotionEffect(this.potionId, this.potionDuration * 20, this.potionAmplifier));
            }
            entityplayer.field_71071_by.func_70441_a(new ItemStack(this.returnItem));
        }
        return itemstack;
    }

    public int func_77626_a(ItemStack itemstack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        return EnumAction.drink;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        this.username = entityplayer.getDisplayName();
        if (this.canDrink() || this.alwaysDrinkable || entityplayer.field_71075_bZ.field_75098_d) {
            entityplayer.func_71008_a(itemstack, this.func_77626_a(itemstack));
        }
        return itemstack;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean flag) {
        super.func_77624_a(stack, player, list, flag);
        String s = Integer.toString(this.thirstReplenish);
        float f = Float.parseFloat(s) / 2.0f;
        String s2 = Float.toString(f);
        list.add("Heals " + (s2.endsWith(".0") ? s2.replace(".0", "") : s2) + " Droplets");
    }

    public ContentDrink setPotionEffect(int i, int j, int k, float f) {
        this.potionId = i;
        this.potionDuration = j;
        this.potionAmplifier = k;
        this.potionEffectProbability = f;
        return this;
    }

    public boolean func_77636_d(ItemStack itemstack) {
        return false;
    }

    public ContentDrink setPoisoningChance(float chance) {
        this.poisonChance = chance;
        return this;
    }

    public Item setHasEffect() {
        return this;
    }

    public ContentDrink setEffect(boolean b) {
        return this;
    }

    public ContentDrink healFood(int level, float saturation) {
        this.foodHeal = level;
        this.satHeal = saturation;
        return this;
    }

    public boolean canDrink() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? PlayerHandler.getPlayer((String)this.username).getStats().level < 20 : StatsHolder.getInstance().level < 20;
    }

    public Item setReturn(Item item) {
        this.returnItem = item;
        return this;
    }

    public Item setCuresPotions(boolean b) {
        this.curesPotion = b;
        return this;
    }

    public Item getReturn() {
        return this.returnItem;
    }

    public IIcon func_77618_c(int par1, int par2) {
        return par2 == 0 ? this.overlay : this.drinkable;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack par1ItemStack, int par2) {
        return par2 > 0 ? 0xFFFFFF : this.colour;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.drinkable = par1IconRegister.func_94245_a("potion_bottle_drinkable");
        this.overlay = par1IconRegister.func_94245_a("potion_overlay");
    }
}

