/*
 * Decompiled with CFR 0.152.
 */
package grim3212.mc.fireplaces;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import grim3212.mc.core.Grim3212Core;
import grim3212.mc.core.GrimModule;
import grim3212.mc.core.packet.PacketPipeline;
import grim3212.mc.core.util.VersionChecker;
import grim3212.mc.fireplaces.BlockChimney;
import grim3212.mc.fireplaces.BlockFirepit;
import grim3212.mc.fireplaces.BlockFireplace;
import grim3212.mc.fireplaces.BlockFirering;
import grim3212.mc.fireplaces.BlockGrill;
import grim3212.mc.fireplaces.BlockStove;
import grim3212.mc.fireplaces.ContainerGrill;
import grim3212.mc.fireplaces.FireplaceClientPacket;
import grim3212.mc.fireplaces.FireplaceServerPacket;
import grim3212.mc.fireplaces.GuiGrill;
import grim3212.mc.fireplaces.ItemFireplaceBase;
import grim3212.mc.fireplaces.RenderChimney;
import grim3212.mc.fireplaces.RenderFirepit;
import grim3212.mc.fireplaces.RenderFireplace;
import grim3212.mc.fireplaces.RenderFirering;
import grim3212.mc.fireplaces.RenderGrill;
import grim3212.mc.fireplaces.RenderStove;
import grim3212.mc.fireplaces.TileEntityChimney;
import grim3212.mc.fireplaces.TileEntityFirepit;
import grim3212.mc.fireplaces.TileEntityFireplace;
import grim3212.mc.fireplaces.TileEntityFirering;
import grim3212.mc.fireplaces.TileEntityGrill;
import grim3212.mc.fireplaces.TileEntityStove;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="grim3212fireplaces", name="Grim3212 Fireplaces", version="V0.1 - 1.7.2", dependencies="required-after:grim3212core")
public class FireplaceCore
extends GrimModule {
    @Mod.Instance(value="grim3212fireplaces")
    public static FireplaceCore instance;
    public static final String modID = "grim3212fireplaces";
    public static final String modName = "Grim3212 Fireplaces";
    public static final String modVersion = "V0.1 - 1.7.2";
    public static final String modURL = "http://grim3212.wikispaces.com/Fireplaces";
    private static VersionChecker versionChecker;
    public static boolean canVersionCheck;
    public static HashMap<Block, Block> TransitionMap;
    public static boolean SettingInfiniteGrillFuel;
    public static boolean SettingRedstoneChimneySmoke;
    public static boolean SettingEnableFirepitNet;
    public static boolean SettingUseNewTopTexture;
    public static boolean SettingEnableFireplace;
    public static boolean SettingEnableChimney;
    public static boolean SettingEnableFirepit;
    public static boolean SettingEnableFirering;
    public static boolean SettingEnableGrill;
    public static boolean SettingEnableStove;
    public static boolean SettingEnableStone;
    public static boolean SettingEnableBrick;
    public static boolean SettingEnableCobblestone;
    public static boolean SettingEnableIron;
    public static boolean SettingEnableGold;
    public static boolean SettingEnableDiamond;
    public static boolean SettingEnableEmerald;
    public static boolean SettingEnableMossyCobblestone;
    public static boolean SettingEnableObsidian;
    public static boolean SettingEnableStoneBricks;
    public static boolean SettingEnableMossyStoneBricks;
    public static boolean SettingEnableCrackedStoneBricks;
    public static boolean SettingEnableNetherrack;
    public static boolean SettingEnableLapis;
    public static boolean SettingEnableEndstone;
    public static boolean SettingEnableNetherBrick;
    public static boolean SettingEnableSandstone;
    public static boolean[] EnabledMaterials;
    public static Block BlockFireplace;
    public static Block BlockFireplaceOn;
    public static Block BlockChimney;
    public static Block BlockFirepit;
    public static Block BlockFirepitOn;
    public static Block BlockFirering;
    public static Block BlockFireringOn;
    public static Block BlockStove;
    public static Block BlockStoveOn;
    public static Block BlockGrill;
    public static Block BlockGrillOn;
    public static Item ItemFireplace;
    public static Item ItemChimney;
    public static Item ItemFirepit;
    public static Item ItemFirering;
    public static Item ItemStove;
    public static Item ItemGrill;
    public static int RenderIDFireplace;
    public static int RenderIDChimney;
    public static int RenderIDFirepit;
    public static int RenderIDFirering;
    public static int RenderIDStove;
    public static int RenderIDGrill;
    public static RenderGrill renderGrill;
    public static ResourceLocation[] BlockResLocs;
    public static Block[] BlockTypes;
    public static char ColorChar;
    public static String[] BlockDescriptions;
    public static int[] ChimneyOutlineColors;
    public static ItemStack[] CraftingTypes;
    public static Item[] ChimneyDropID;
    public static int[] ChimneyDropData;
    public static int[] GrillTiers;
    public static HashMap<Item, Item> GrillRecipes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModMetadata data = event.getModMetadata();
        data.autogenerated = false;
        data.version = modVersion;
        data.name = modName;
        data.description = "Adds fireplaces, grills, chimneys and more to your minecraft world.";
        data.authorList.add("Grim3212");
        data.authorList.add("ngphoenix");
        data.url = modURL;
        data.credits = "Thanks to ngphoenix for the original mod.";
        data.logoFile = "assets/grim3212-logo-texture/grimLogo.png";
        Configuration config = new Configuration(new File(event.getModConfigurationDirectory().getAbsolutePath() + File.separator + "/GrimsMods/" + this.getModID() + ".cfg"));
        try {
            config.load();
            SettingEnableFirepitNet = config.get("Settings", "EnableFirepitNet", true).getBoolean(true);
            SettingInfiniteGrillFuel = config.get("Settings", "InfiniteGrillFuel", false).getBoolean(false);
            SettingUseNewTopTexture = config.get("Settings", "UseNewTopTexture", false).getBoolean(false);
            SettingEnableFireplace = config.get("BlockSettings", "EnableFireplace", true).getBoolean(true);
            SettingEnableChimney = config.get("BlockSettings", "EnableChimney", true).getBoolean(true);
            SettingEnableFirepit = config.get("BlockSettings", "EnableFirepit", true).getBoolean(true);
            SettingEnableFirering = config.get("BlockSettings", "EnableFirering", true).getBoolean(true);
            SettingEnableGrill = config.get("BlockSettings", "EnableGrill", true).getBoolean(true);
            SettingEnableStove = config.get("BlockSettings", "EnableStove", true).getBoolean(true);
            SettingEnableStone = config.get("MaterialSettings", "EnableStone", true).getBoolean(true);
            SettingEnableBrick = config.get("MaterialSettings", "EnableBrick", true).getBoolean(true);
            SettingEnableCobblestone = config.get("MaterialSettings", "EnableCobblestone", true).getBoolean(true);
            SettingEnableIron = config.get("MaterialSettings", "EnableIron", true).getBoolean(true);
            SettingEnableGold = config.get("MaterialSettings", "EnableGold", true).getBoolean(true);
            SettingEnableDiamond = config.get("MaterialSettings", "EnableDiamond", true).getBoolean(true);
            SettingEnableEmerald = config.get("MaterialSettings", "EnableEmerald", true).getBoolean(true);
            SettingEnableMossyCobblestone = config.get("MaterialSettings", "EnableMossyCobblestone", true).getBoolean(true);
            SettingEnableObsidian = config.get("MaterialSettings", "EnableObsidian", true).getBoolean(true);
            SettingEnableStoneBricks = config.get("MaterialSettings", "EnableStoneBricks", true).getBoolean(true);
            SettingEnableMossyStoneBricks = config.get("MaterialSettings", "EnableMossyStoneBricks", true).getBoolean(true);
            SettingEnableCrackedStoneBricks = config.get("MaterialSettings", "EnableCrackedStoneBricks", true).getBoolean(true);
            SettingEnableNetherrack = config.get("MaterialSettings", "EnableNetherrack", true).getBoolean(true);
            SettingEnableLapis = config.get("MaterialSettings", "EnableLapis", true).getBoolean(true);
            SettingEnableEndstone = config.get("MaterialSettings", "EnableEndstone", true).getBoolean(true);
            SettingEnableNetherBrick = config.get("MaterialSettings", "EnableNetherBrick", true).getBoolean(true);
            SettingEnableSandstone = config.get("MaterialSettings", "EnableSandstone", true).getBoolean(true);
            EnabledMaterials = new boolean[]{SettingEnableStone, SettingEnableBrick, SettingEnableCobblestone, SettingEnableIron, SettingEnableGold, SettingEnableDiamond, SettingEnableEmerald, SettingEnableMossyCobblestone, SettingEnableObsidian, SettingEnableStoneBricks, SettingEnableMossyStoneBricks, SettingEnableCrackedStoneBricks, SettingEnableNetherrack, SettingEnableLapis, SettingEnableEndstone, SettingEnableNetherBrick, SettingEnableSandstone};
            config.get("CustomGrillRecipes", "Placeholder", "clay_ball>brick");
            config.addCustomCategoryComment("CustomGrillRecipes", "HOW TO ADD CUSTOM GRILL RECIPES\nS:[Unique Name]=[RawItemID]>[CookedItemID]\nEXAMPLE    S:ClayToBrick=clay_ball>brick");
            ConfigCategory CustomGrillRecipes = config.getCategory("customgrillrecipes");
            for (String uniquename : CustomGrillRecipes.keySet()) {
                System.out.println("[Fireplaces] Fireplace mod found unique recipe: " + uniquename);
                try {
                    String[] rawids = CustomGrillRecipes.get(uniquename).getString().split(">");
                    Item rawid1 = (Item)Item.field_150901_e.func_82594_a(rawids[0]);
                    Item rawid2 = (Item)Item.field_150901_e.func_82594_a(rawids[1]);
                    GrillRecipes.put(rawid1, rawid2);
                    System.out.println("[Fireplaces] " + (rawid1 != null ? rawid1.func_77658_a() : rawid1) + " will now smelt into " + (rawid2 != null ? rawid2.func_77658_a() : rawid2));
                }
                catch (Exception e) {
                    System.out.println("[Fireplaces] Failed to add this recipe!");
                }
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Grim3212 Fireplaces has had a problem loading it's configuration", (Object[])new Object[]{e});
        }
        finally {
            config.save();
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)this);
        PacketPipeline.registerPacket(FireplaceClientPacket.class);
        PacketPipeline.registerPacket(FireplaceServerPacket.class);
        if (SettingEnableFireplace) {
            BlockFireplace = new BlockFireplace(true).func_149663_c("blockfireplace");
            BlockFireplaceOn = new BlockFireplace(false).func_149715_a(1.0f).func_149663_c("blockfireplaceon");
            ItemFireplace = new ItemFireplaceBase(BlockFireplace);
            GameRegistry.registerBlock((Block)BlockFireplace, ItemFireplaceBase.class, (String)("grim3212-" + BlockFireplace.func_149739_a()));
            GameRegistry.registerBlock((Block)BlockFireplaceOn, ItemFireplaceBase.class, (String)("grim3212-" + BlockFireplaceOn.func_149739_a()));
            TransitionMap.put(BlockFireplace, BlockFireplaceOn);
            TransitionMap.put(BlockFireplaceOn, BlockFireplace);
            this.BuildRecipes(BlockFireplace, "MMM", "MPM", "MMM", 1);
            GameRegistry.registerTileEntity(TileEntityFireplace.class, (String)"Fireplace");
        }
        if (SettingEnableChimney) {
            BlockChimney = new BlockChimney().func_149663_c("blockchimney");
            GameRegistry.registerBlock((Block)BlockChimney, ItemFireplaceBase.class, (String)("grim3212-" + BlockChimney.func_149739_a()));
            this.BuildRecipes(BlockChimney, "M M", "M M", "M M", 6);
            GameRegistry.registerTileEntity(TileEntityChimney.class, (String)"Chimney");
        }
        if (SettingEnableFirepit) {
            BlockFirepit = new BlockFirepit(true).func_149663_c("blockfirepit");
            BlockFirepitOn = new BlockFirepit(false).func_149715_a(1.0f).func_149663_c("blockfirepiton");
            ItemFirepit = new ItemFireplaceBase(BlockFirepit);
            GameRegistry.registerBlock((Block)BlockFirepit, ItemFireplaceBase.class, (String)("grim3212-" + BlockFirepit.func_149739_a()));
            GameRegistry.registerBlock((Block)BlockFirepitOn, ItemFireplaceBase.class, (String)("grim3212-" + BlockFirepitOn.func_149739_a()));
            TransitionMap.put(BlockFirepit, BlockFirepitOn);
            TransitionMap.put(BlockFirepitOn, BlockFirepit);
            this.BuildRecipes(BlockFirepit, " I ", "MPM", "MMM", 1);
            GameRegistry.registerTileEntity(TileEntityFirepit.class, (String)"Firepit");
        }
        if (SettingEnableFirering) {
            BlockFirering = new BlockFirering(true).func_149663_c("blockfirering");
            BlockFireringOn = new BlockFirering(false).func_149715_a(1.0f).func_149663_c("blockfireringon");
            ItemFirering = new ItemFireplaceBase(BlockFirering);
            GameRegistry.registerBlock((Block)BlockFirering, ItemFireplaceBase.class, (String)("grim3212-" + BlockFirering.func_149739_a()));
            GameRegistry.registerBlock((Block)BlockFireringOn, ItemFireplaceBase.class, (String)("grim3212-" + BlockFireringOn.func_149739_a()));
            TransitionMap.put(BlockFirering, BlockFireringOn);
            TransitionMap.put(BlockFireringOn, BlockFirering);
            this.BuildRecipes(BlockFirering, " M ", "MPM", " M ", 1);
            GameRegistry.registerTileEntity(TileEntityFirering.class, (String)"Firering");
        }
        if (SettingEnableStove) {
            BlockStove = new BlockStove(true).func_149663_c("blockstove");
            BlockStoveOn = new BlockStove(false).func_149715_a(1.0f).func_149663_c("blockstoveon");
            ItemStove = new ItemFireplaceBase(BlockStove);
            GameRegistry.registerBlock((Block)BlockStove, ItemFireplaceBase.class, (String)("grim3212-" + BlockStove.func_149739_a()));
            GameRegistry.registerBlock((Block)BlockStoveOn, ItemFireplaceBase.class, (String)("grim3212-" + BlockStoveOn.func_149739_a()));
            TransitionMap.put(BlockStove, BlockStoveOn);
            TransitionMap.put(BlockStoveOn, BlockStove);
            this.BuildRecipes(BlockStove, "MMM", "BPB", "MMM", 1);
            GameRegistry.registerTileEntity(TileEntityStove.class, (String)"Stove");
        }
        if (SettingEnableGrill) {
            BlockGrill = new BlockGrill(true).func_149663_c("blockgrill");
            BlockGrillOn = new BlockGrill(false).func_149715_a(1.0f).func_149663_c("blockgrillon");
            ItemGrill = new ItemFireplaceBase(BlockGrill);
            GameRegistry.registerBlock((Block)BlockGrill, ItemFireplaceBase.class, (String)("grim3212-" + BlockGrill.func_149739_a()));
            GameRegistry.registerBlock((Block)BlockGrillOn, ItemFireplaceBase.class, (String)("grim3212-" + BlockGrillOn.func_149739_a()));
            TransitionMap.put(BlockGrill, BlockGrillOn);
            TransitionMap.put(BlockGrillOn, BlockGrill);
            this.BuildRecipes(BlockGrill, "MCM", "MMM", " M ", 1);
            this.BuildRecipes(BlockGrill, "MHM", "MMM", " M ", 1);
            GameRegistry.registerTileEntity(TileEntityGrill.class, (String)"Grill");
            GrillRecipes.put(Items.field_151147_al, Items.field_151157_am);
            GrillRecipes.put(Items.field_151082_bd, Items.field_151083_be);
            GrillRecipes.put(Items.field_151115_aP, Items.field_151101_aQ);
            GrillRecipes.put(Items.field_151076_bf, Items.field_151077_bg);
            GrillRecipes.put(Items.field_151174_bG, Items.field_151168_bH);
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)this);
        if (Grim3212Core.doUpdateCheck) {
            versionChecker = new VersionChecker(modName, modVersion, this.versionUrl, modURL);
            versionChecker.checkVersionWithLoggingBySubStringAsFloat(1, 4);
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.initClient();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initClient() {
        BlockResLocs = new ResourceLocation[BlockTypes.length];
        for (int i = 0; i < BlockResLocs.length; ++i) {
            FireplaceCore.BlockResLocs[i] = new ResourceLocation("textures/blocks/" + BlockTypes[i].func_149733_h(0).func_94215_i() + ".png");
        }
        if (SettingEnableFireplace) {
            RenderIDFireplace = RenderingRegistry.getNextAvailableRenderId();
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderFireplace());
        }
        if (SettingEnableChimney) {
            RenderIDChimney = RenderingRegistry.getNextAvailableRenderId();
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderChimney());
        }
        if (SettingEnableFirepit) {
            RenderIDFirepit = RenderingRegistry.getNextAvailableRenderId();
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderFirepit());
        }
        if (SettingEnableFirering) {
            RenderIDFirering = RenderingRegistry.getNextAvailableRenderId();
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderFirering());
        }
        if (SettingEnableStove) {
            RenderIDStove = RenderingRegistry.getNextAvailableRenderId();
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderStove());
        }
        if (SettingEnableGrill) {
            renderGrill = new RenderGrill();
            RenderIDGrill = RenderingRegistry.getNextAvailableRenderId();
            RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)renderGrill);
        }
    }

    private void BuildRecipes(Object item, String row1, String row2, String row3, int count) {
        Block nameid = item instanceof Block ? (Block)item : (Item)item;
        for (int i = 0; i < BlockTypes.length; ++i) {
            if (!EnabledMaterials[i]) continue;
            GameRegistry.addRecipe((ItemStack)new ItemStack(nameid, count, i), (Object[])this.translateRecipe(row1, row2, row3, i));
        }
    }

    private Object[] translateRecipe(String row1, String row2, String row3, int i) {
        ArrayList<Object> obj = new ArrayList<Object>();
        obj.add(row1);
        obj.add(row2);
        obj.add(row3);
        obj.add(Character.valueOf('M'));
        obj.add(CraftingTypes[i]);
        if (row1.contains("P") || row2.contains("P") || row3.contains("P")) {
            obj.add(Character.valueOf('P'));
            obj.add(Blocks.field_150344_f);
        }
        if (row1.contains("I") || row2.contains("I") || row3.contains("I")) {
            obj.add(Character.valueOf('I'));
            obj.add(Items.field_151042_j);
        }
        if (row1.contains("C") || row2.contains("C") || row3.contains("C")) {
            obj.add(Character.valueOf('C'));
            obj.add(Items.field_151044_h);
        }
        if (row1.contains("H") || row2.contains("H") || row3.contains("H")) {
            obj.add(Character.valueOf('H'));
            obj.add(new ItemStack(Items.field_151044_h, 1, 1));
        }
        if (row1.contains("B") || row2.contains("B") || row3.contains("B")) {
            obj.add(Character.valueOf('B'));
            obj.add(Blocks.field_150411_aY);
        }
        return obj.toArray();
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (FMLClientHandler.instance().getClient().field_71462_r == null && Grim3212Core.doUpdateCheck) {
            if (canVersionCheck && !versionChecker.isCurrentVersionBySubStringAsFloatNewer(1, 4)) {
                for (String msg : versionChecker.getInGameMessage()) {
                    FMLClientHandler.instance().getClient().field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText(msg));
                }
                canVersionCheck = false;
            }
        }
    }

    public String getModID() {
        return modID;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tileentity = world.func_147438_o(x, y, z);
        if (ID == 0 && tileentity instanceof TileEntityGrill) {
            return new ContainerGrill(player.field_71071_by, (TileEntityGrill)tileentity);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tileentity = world.func_147438_o(x, y, z);
        if (ID == 0 && tileentity instanceof TileEntityGrill) {
            return new GuiGrill(player.field_71071_by, (TileEntityGrill)tileentity);
        }
        return null;
    }

    static {
        canVersionCheck = true;
        TransitionMap = new HashMap();
        SettingInfiniteGrillFuel = false;
        SettingRedstoneChimneySmoke = false;
        SettingEnableFirepitNet = true;
        SettingUseNewTopTexture = true;
        SettingEnableFireplace = true;
        SettingEnableChimney = true;
        SettingEnableFirepit = true;
        SettingEnableFirering = true;
        SettingEnableGrill = true;
        SettingEnableStove = true;
        SettingEnableStone = true;
        SettingEnableBrick = true;
        SettingEnableCobblestone = true;
        SettingEnableIron = true;
        SettingEnableGold = true;
        SettingEnableDiamond = true;
        SettingEnableEmerald = true;
        SettingEnableMossyCobblestone = true;
        SettingEnableObsidian = true;
        SettingEnableStoneBricks = true;
        SettingEnableMossyStoneBricks = true;
        SettingEnableCrackedStoneBricks = true;
        SettingEnableNetherrack = true;
        SettingEnableLapis = true;
        SettingEnableEndstone = true;
        SettingEnableNetherBrick = true;
        SettingEnableSandstone = true;
        BlockTypes = new Block[]{Blocks.field_150348_b, Blocks.field_150336_V, Blocks.field_150347_e, Blocks.field_150339_S, Blocks.field_150340_R, Blocks.field_150484_ah, Blocks.field_150475_bE, Blocks.field_150341_Y, Blocks.field_150343_Z, Blocks.field_150417_aV, Blocks.field_150417_aV, Blocks.field_150417_aV, Blocks.field_150424_aL, Blocks.field_150368_y, Blocks.field_150377_bs, Blocks.field_150385_bj, Blocks.field_150322_A};
        ColorChar = (char)167;
        BlockDescriptions = new String[]{ColorChar + "7Stone", ColorChar + "cBricks", ColorChar + "8Cobblestone", ColorChar + "7Iron Block", ColorChar + "6Gold Block", ColorChar + "bDiamond Block", ColorChar + "aEmerald Block", ColorChar + "2Mossy Cobblestone", ColorChar + "5Obsidian", ColorChar + "7Stone Bricks", ColorChar + "2Mossy Stone Bricks", ColorChar + "8Cracked Stone Bricks", ColorChar + "4Netherrack", ColorChar + "9Lapis Block", ColorChar + "eEndstone", ColorChar + "4Nether Bricks", ColorChar + "eSandstone"};
        ChimneyOutlineColors = new int[]{0x323232, 0xD3D3D3, 0x323232, 0xAAAAAA, 12946208, 50362, 2522880, 0x323232, 0x323232, 0x323232, 0x323232, 0x323232, 4982535, 1323386, 11510880, 1641743, 11510880};
        CraftingTypes = new ItemStack[]{new ItemStack(Blocks.field_150348_b, 1, 0), new ItemStack(Items.field_151118_aC, 1, 0), new ItemStack(Blocks.field_150347_e, 1, 0), new ItemStack(Items.field_151042_j, 1, 0), new ItemStack(Items.field_151043_k, 1, 0), new ItemStack(Items.field_151045_i, 1, 0), new ItemStack(Items.field_151166_bC, 1, 0), new ItemStack(Blocks.field_150341_Y, 1, 0), new ItemStack(Blocks.field_150343_Z, 1, 0), new ItemStack(Blocks.field_150417_aV, 1, 0), new ItemStack(Blocks.field_150417_aV, 1, 1), new ItemStack(Blocks.field_150417_aV, 1, 2), new ItemStack(Blocks.field_150424_aL, 1, 0), new ItemStack(Items.field_151100_aR, 1, 4), new ItemStack(Blocks.field_150377_bs, 1, 0), new ItemStack(Blocks.field_150385_bj, 1, 0), new ItemStack(Blocks.field_150322_A, 1, 0)};
        ChimneyDropID = new Item[]{Item.func_150898_a((Block)Blocks.field_150348_b), Items.field_151118_aC, Item.func_150898_a((Block)Blocks.field_150347_e), Items.field_151042_j, Items.field_151043_k, Items.field_151045_i, Items.field_151166_bC, Item.func_150898_a((Block)Blocks.field_150341_Y), Item.func_150898_a((Block)Blocks.field_150343_Z), Item.func_150898_a((Block)Blocks.field_150417_aV), Item.func_150898_a((Block)Blocks.field_150417_aV), Item.func_150898_a((Block)Blocks.field_150417_aV), Item.func_150898_a((Block)Blocks.field_150424_aL), Items.field_151100_aR, Item.func_150898_a((Block)Blocks.field_150377_bs), Item.func_150898_a((Block)Blocks.field_150385_bj), Item.func_150898_a((Block)Blocks.field_150322_A)};
        ChimneyDropData = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 4, 0, 0, 0};
        GrillTiers = new int[]{2, 2, 1, 4, 5, 6, 6, 2, 3, 2, 3, 3, 1, 3, 3, 2, 2};
        GrillRecipes = new HashMap();
    }
}

