/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.network;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gory_moon.moarsigns.network.AbstractPacket;
import gory_moon.moarsigns.network.PacketPipeline;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.world.WorldServer;

public class PacketSignUpdate
extends AbstractPacket {
    public int fontSize;
    public int offset;
    public int posX;
    public int posY;
    public int posZ;
    public String[] text = new String[]{"", "", "", ""};

    public PacketSignUpdate() {
    }

    public PacketSignUpdate(int posX, int posY, int posZ, String[] text, int fontSize, int offset) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.text = text;
        this.fontSize = fontSize;
        this.offset = offset;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.fontSize);
        buffer.writeInt(this.offset);
        buffer.writeInt(this.posX);
        buffer.writeInt(this.posY);
        buffer.writeInt(this.posZ);
        for (int i = 0; i < 4; ++i) {
            try {
                PacketPipeline.writeString(this.text[i], buffer);
                continue;
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.fontSize = buffer.readInt();
        this.offset = buffer.readInt();
        this.posX = buffer.readInt();
        this.posY = buffer.readInt();
        this.posZ = buffer.readInt();
        for (int i = 0; i < 4; ++i) {
            try {
                this.text[i] = PacketPipeline.readStringFromBuffer(15, buffer);
                continue;
            }
            catch (IOException ignored) {
                this.text[i] = "";
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        TileEntity tileentity;
        ((EntityPlayerMP)player).func_143004_u();
        WorldServer worldserver = MinecraftServer.func_71276_C().func_71218_a(player.field_71093_bK);
        if (worldserver.func_72899_e(this.posX, this.posY, this.posZ) && (tileentity = worldserver.func_147438_o(this.posX, this.posY, this.posZ)) instanceof TileEntitySign) {
            int rows;
            TileEntitySign sign = (TileEntitySign)tileentity;
            if (!sign.func_145914_a() || sign.func_145911_b() != player) {
                MinecraftServer.func_71276_C().func_71236_h("Player " + player.func_70005_c_() + " just tried to change non-editable sign");
                return;
            }
            int n = this.fontSize > 15 ? 1 : (this.fontSize > 5 ? 2 : (rows = this.fontSize > 1 ? 3 : 4));
            int maxLength = this.fontSize > 17 ? 5 : (this.fontSize > 13 ? 6 : (this.fontSize > 10 ? 7 : (this.fontSize > 7 ? 8 : (this.fontSize > 5 ? 9 : (this.fontSize > 4 ? 11 : (this.fontSize > 1 ? 12 : (this.fontSize > 0 ? 13 : 15)))))));
            for (int i = 0; i < 4; ++i) {
                boolean flag = true;
                this.text[i] = this.text[i].substring(0, Math.min(this.text[i].length(), maxLength));
                if (i > rows) {
                    this.text[i] = "";
                }
                for (int j = 0; j < this.text[i].length(); ++j) {
                    if (ChatAllowedCharacters.func_71566_a((char)this.text[i].charAt(j))) continue;
                    flag = false;
                }
                if (flag) continue;
                this.text[i] = "!?";
            }
            ((TileEntityMoarSign)sign).fontSize = this.fontSize;
            ((TileEntityMoarSign)sign).textOffset = this.offset;
            System.arraycopy(this.text, 0, sign.field_145915_a, 0, 4);
            sign.func_70296_d();
            worldserver.func_147471_g(this.posX, this.posY, this.posZ);
        }
    }
}

