/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.network;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gory_moon.moarsigns.network.AbstractPacket;
import gory_moon.moarsigns.network.PacketPipeline;
import gory_moon.moarsigns.network.PacketSignUpdate;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketSignMainInfo
extends AbstractPacket {
    public String texture;
    public boolean isMetal;
    public int activeMaterialIndex;
    public int id;
    public int meta;
    public boolean markDirty = true;
    public boolean skipChecks = false;
    public TileEntityMoarSign skipTileEntity = null;
    public PacketSignUpdate signUpdate = new PacketSignUpdate();

    public PacketSignMainInfo() {
    }

    public PacketSignMainInfo(String texture, boolean isMetal, int activeMaterialIndex, int id, int meta, int fontSize, int offset, String[] text, int posX, int posY, int posZ) {
        this.texture = texture;
        this.isMetal = isMetal;
        this.activeMaterialIndex = activeMaterialIndex;
        this.id = id;
        this.meta = meta;
        this.signUpdate.fontSize = fontSize;
        this.signUpdate.offset = offset;
        this.signUpdate.text = text;
        this.signUpdate.posX = posX;
        this.signUpdate.posY = posY;
        this.signUpdate.posZ = posZ;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        try {
            PacketPipeline.writeString(this.texture, buffer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        buffer.writeBoolean(this.isMetal);
        buffer.writeInt(this.activeMaterialIndex);
        buffer.writeInt(this.id);
        buffer.writeInt(this.meta);
        this.signUpdate.encodeInto(ctx, buffer);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        try {
            this.texture = PacketPipeline.readStringFromBuffer(30 + "_sign".length(), buffer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.isMetal = buffer.readBoolean();
        this.activeMaterialIndex = buffer.readInt();
        this.id = buffer.readInt();
        this.meta = buffer.readInt();
        this.signUpdate.decodeInto(ctx, buffer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (this.skipChecks || world.func_72899_e(this.signUpdate.posX, this.signUpdate.posY, this.signUpdate.posZ)) {
            TileEntity tileentity = world.func_147438_o(this.signUpdate.posX, this.signUpdate.posY, this.signUpdate.posZ);
            if (this.skipChecks || tileentity instanceof TileEntityMoarSign) {
                TileEntityMoarSign sign = (TileEntityMoarSign)tileentity;
                if (this.skipChecks) {
                    sign = this.skipTileEntity;
                }
                sign.isMetal = this.isMetal;
                sign.activeMaterialIndex = this.activeMaterialIndex;
                sign.materialId = this.id;
                sign.materialMeta = this.meta;
                sign.fontSize = this.signUpdate.fontSize;
                sign.textOffset = this.signUpdate.offset;
                sign.setResourceLocation(this.texture);
                if (sign.isEditable()) {
                    System.arraycopy(this.signUpdate.text, 0, sign.field_145915_a, 0, 4);
                    if (this.markDirty) {
                        sign.func_70296_d();
                    }
                }
            }
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

