/*
 * Decompiled with CFR 0.152.
 */
package gory_moon.moarsigns.items;

import gory_moon.moarsigns.MoarSigns;
import gory_moon.moarsigns.blocks.Blocks;
import gory_moon.moarsigns.items.Items;
import gory_moon.moarsigns.network.PacketOpenMoarSignsGui;
import gory_moon.moarsigns.tileentites.TileEntityMoarSign;
import gory_moon.moarsigns.util.Signs;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemMoarSign
extends Item {
    public ItemMoarSign() {
        this.field_77777_bU = 16;
        this.func_77637_a(MoarSigns.instance.tabMS);
        this.func_77655_b("moarsign");
        this.field_77787_bX = true;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + this.getTextureFromNBT(stack.func_77978_p());
    }

    public void func_94581_a(IIconRegister register) {
        ArrayList signs = (ArrayList)MoarSigns.instance.getTempWoodSigns().clone();
        signs.addAll((ArrayList)MoarSigns.instance.getTempMetalSigns().clone());
        for (Signs s : signs) {
            for (Signs.Material material : s.material) {
                String path = material.path;
                String loc = s.isMetal ? "metal/" : "wood/";
                IIcon icon = register.func_94245_a("moarsigns:" + loc + (path.equals("") ? "" : path.replace("\\", "/")) + s.itemTexture);
                MoarSigns.icons.put((path.equals("") ? "" : path) + s.signName, icon);
            }
        }
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        this.getSubItemStacks(list);
    }

    public void getSubItemStacks(List list) {
        ArrayList signs = (ArrayList)MoarSigns.instance.getSignsWood().clone();
        signs.addAll((ArrayList)MoarSigns.instance.getSignsMetal().clone());
        for (Signs s : signs) {
            String path = s.material[s.activeMaterialIndex].path;
            list.add(this.createMoarItemStack((path.equals("") ? "" : path) + s.signName, s.isMetal));
        }
    }

    public String func_77653_i(ItemStack stack) {
        Signs sign = this.getSignFromNBT(stack.func_77978_p());
        return sign != null ? sign.itemName : "MoarSign";
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        Signs sign = this.getSignFromNBT(stack.func_77978_p());
        if (sign == null) {
            return MoarSigns.icons.get("oak_sign");
        }
        String path = sign.material[sign.activeMaterialIndex].path;
        return MoarSigns.icons.get((path.equals("") ? "" : path) + sign.signName);
    }

    public IIcon func_77650_f(ItemStack stack) {
        return this.getIcon(stack, 0);
    }

    public ItemStack createMoarItemStack(String signName, boolean isMetal) {
        ItemStack itemStack = new ItemStack((Item)this, 1, isMetal ? 1 : 0);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("SignTexture", signName.replace("\\", "/"));
        itemStack.func_77982_d(compound);
        return itemStack;
    }

    public Signs getSignFromNBT(NBTTagCompound nbt) {
        ArrayList signs = (ArrayList)MoarSigns.instance.getSignsWood().clone();
        signs.addAll((ArrayList)MoarSigns.instance.getSignsMetal().clone());
        String texture = this.getTextureFromNBTFull(nbt);
        for (Signs s : signs) {
            if (!(s.material[s.activeMaterialIndex].path.replace("\\", "/") + s.signName).equals(texture)) continue;
            return s;
        }
        return null;
    }

    public String getTextureFromNBTFull(NBTTagCompound compound) {
        String texture = compound.func_74764_b("SignTexture") ? compound.func_74779_i("SignTexture") : "";
        return texture;
    }

    public String getTextureFromNBT(NBTTagCompound compound) {
        String texture;
        String string = texture = compound.func_74764_b("SignTexture") ? compound.func_74779_i("SignTexture") : "";
        if (texture.contains("\\")) {
            texture = texture.split("\\\\")[1];
        }
        if (texture.contains("/")) {
            texture = texture.split("/")[1];
        }
        return texture;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntityMoarSign tileEntity;
        if (side == 0 || !world.func_147439_a(x, y, z).func_149688_o().func_76220_a()) {
            return false;
        }
        switch (side) {
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
            }
        }
        if (!player.func_82247_a(x, y, z, side, stack) || !Blocks.signStandingWood.func_149742_c(world, x, y, z) || world.field_72995_K) {
            return false;
        }
        if (side == 1) {
            int rotation = MathHelper.func_76128_c((double)((double)((player.field_70177_z + 180.0f) * 16.0f / 360.0f) + 0.5)) & 0xF;
            if (stack.func_77960_j() == 0) {
                world.func_147465_d(x, y, z, Blocks.signStandingWood, rotation, 3);
            } else if (stack.func_77960_j() == 1) {
                world.func_147465_d(x, y, z, Blocks.signStandingMetal, rotation, 3);
            }
        } else if (stack.func_77960_j() == 0) {
            world.func_147465_d(x, y, z, Blocks.signWallWood, side, 3);
        } else if (stack.func_77960_j() == 1) {
            world.func_147465_d(x, y, z, Blocks.signWallMetal, side, 3);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
        if ((tileEntity = (TileEntityMoarSign)world.func_147438_o(x, y, z)) != null) {
            Signs sign = Items.sign.getSignFromNBT(stack.func_77978_p());
            String texture = this.getTextureFromNBTFull(stack.func_77978_p());
            if (sign == null) {
                return false;
            }
            tileEntity.setResourceLocation(texture);
            tileEntity.isMetal = sign.isMetal;
            tileEntity.materialId = sign.material[sign.activeMaterialIndex].matId;
            tileEntity.materialMeta = sign.material[sign.activeMaterialIndex].matMeta;
            tileEntity.activeMaterialIndex = sign.activeMaterialIndex;
            tileEntity.func_145912_a(player);
            MoarSigns.packetPipeline.sendTo(new PacketOpenMoarSignsGui(texture, tileEntity.isMetal, tileEntity.activeMaterialIndex, tileEntity.materialId, tileEntity.materialMeta, tileEntity.fontSize, tileEntity.textOffset, new String[]{"", "", "", ""}, x, y, z), (EntityPlayerMP)player);
        }
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean extraInfo) {
    }
}

